/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.glassfish.jersey.inject.cdi.se.ParameterizedTypeImpl;
import org.glassfish.jersey.inject.cdi.se.bean.JerseyBean;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;

class SupplierBeanBridge
extends JerseyBean<Object> {
    private final BeanManager beanManager;
    private ParameterizedType type;
    private boolean disposable;
    private SupplierClassBinding binding;
    private final Map<Object, DisposableSupplier<Object>> disposableSuppliers = new IdentityHashMap<Object, DisposableSupplier<Object>>();

    SupplierBeanBridge(SupplierClassBinding binding, BeanManager beanManager) {
        super(binding);
        Type contract = null;
        if (binding.getContracts().iterator().hasNext()) {
            contract = (Type)binding.getContracts().iterator().next();
        }
        this.binding = binding;
        this.beanManager = beanManager;
        this.disposable = DisposableSupplier.class.isAssignableFrom(binding.getSupplierClass());
        this.type = new ParameterizedTypeImpl((Type)((Object)Supplier.class), contract);
    }

    public Object create(CreationalContext creationalContext) {
        if (this.type != null) {
            Supplier<?> supplier = SupplierBeanBridge.getSupplier(this.beanManager, this.type);
            Object instance = supplier.get();
            if (this.disposable) {
                this.disposableSuppliers.put(instance, (DisposableSupplier<Object>)((DisposableSupplier)supplier));
            }
            return instance;
        }
        return null;
    }

    @Override
    public void destroy(Object instance, CreationalContext context) {
        if (this.disposable) {
            DisposableSupplier<Object> disposableSupplier = this.disposableSuppliers.get(instance);
            disposableSupplier.dispose(instance);
            this.disposableSuppliers.remove(instance);
        }
    }

    private static Supplier<?> getSupplier(BeanManager beanManager, ParameterizedType supplierType) {
        Set beans = beanManager.getBeans((Type)supplierType, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        return (Supplier)beanManager.getReference(bean, (Type)supplierType, ctx);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.binding.getScope() == null ? Dependent.class : SupplierBeanBridge.transformScope(this.binding.getScope());
    }

    @Override
    public Class<?> getBeanClass() {
        return this.binding.getContracts().isEmpty() ? super.getBeanClass() : (Class)this.binding.getContracts().iterator().next();
    }
}

