/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.WithAnnotations;
import org.glassfish.jersey.inject.cdi.se.RequestScopeBean;
import org.glassfish.jersey.inject.cdi.se.bean.BeanHelper;
import org.glassfish.jersey.inject.cdi.se.injector.JerseyInjectionTarget;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.InjectionResolverBinding;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.jboss.weld.injection.producer.BasicInjectionTarget;

class SeBeanRegisterExtension
implements Extension {
    private final AbstractBinder bindings;
    private final List<JerseyInjectionTarget> jerseyInjectionTargets = new ArrayList<JerseyInjectionTarget>();

    SeBeanRegisterExtension(AbstractBinder bindings) {
        this.bindings = bindings;
    }

    public <T> void ignoreManuallyRegisteredComponents(@Observes @WithAnnotations(value={Path.class, Provider.class}) ProcessAnnotatedType<T> pat) {
        for (Binding binding : this.bindings.getBindings()) {
            if (ClassBinding.class.isAssignableFrom(binding.getClass())) {
                ClassBinding classBinding = (ClassBinding)binding;
                if (pat.getAnnotatedType().getJavaClass() != classBinding.getService()) continue;
                pat.veto();
                return;
            }
            if (!InstanceBinding.class.isAssignableFrom(binding.getClass())) continue;
            InstanceBinding instanceBinding = (InstanceBinding)binding;
            if (pat.getAnnotatedType().getJavaClass() != instanceBinding.getService().getClass()) continue;
            pat.veto();
            return;
        }
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> pit) {
        BasicInjectionTarget it = (BasicInjectionTarget)pit.getInjectionTarget();
        JerseyInjectionTarget jerseyInjectionTarget = new JerseyInjectionTarget(it, pit.getAnnotatedType().getJavaClass());
        this.jerseyInjectionTargets.add(jerseyInjectionTarget);
        pit.setInjectionTarget(jerseyInjectionTarget);
    }

    public void registerBeans(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        Collection bindings = this.bindings.getBindings();
        List<InjectionResolver> injectionResolvers = bindings.stream().filter(binding -> InjectionResolverBinding.class.isAssignableFrom(binding.getClass())).map(InjectionResolverBinding.class::cast).map(InjectionResolverBinding::getResolver).collect(Collectors.toList());
        this.jerseyInjectionTargets.forEach(injectionTarget -> injectionTarget.setInjectionResolvers(injectionResolvers));
        for (Binding binding2 : bindings) {
            if (ClassBinding.class.isAssignableFrom(binding2.getClass())) {
                BeanHelper.registerBean((ClassBinding)binding2, abd, injectionResolvers, beanManager);
                continue;
            }
            if (InstanceBinding.class.isAssignableFrom(binding2.getClass())) {
                BeanHelper.registerBean((InstanceBinding)binding2, abd, injectionResolvers);
                continue;
            }
            if (SupplierClassBinding.class.isAssignableFrom(binding2.getClass())) {
                BeanHelper.registerSupplier((SupplierClassBinding)binding2, abd, injectionResolvers, beanManager);
                continue;
            }
            if (!SupplierInstanceBinding.class.isAssignableFrom(binding2.getClass())) continue;
            BeanHelper.registerSupplier((SupplierInstanceBinding)binding2, abd, beanManager);
        }
        abd.addBean((Bean)new RequestScopeBean(beanManager));
    }
}

