/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.glassfish.jersey.inject.cdi.se.bean.JerseyBean;
import org.glassfish.jersey.internal.inject.ClassBinding;

class ClassBean<T>
extends JerseyBean<T> {
    private final ClassBinding<T> binding;
    private InjectionTarget<T> injectionTarget;

    ClassBean(ClassBinding<T> binding) {
        super(binding);
        this.binding = binding;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        if (ClassBean.isResourceClass(this.binding.getService()) && this.binding.getScope() == null) {
            return RequestScoped.class;
        }
        return this.binding.getScope() == null ? Dependent.class : ClassBean.transformScope(this.binding.getScope());
    }

    public T create(CreationalContext<T> context) {
        Object instance = this.injectionTarget.produce(context);
        this.injectionTarget.inject(instance, context);
        this.injectionTarget.postConstruct(instance);
        return (T)instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> context) {
        this.injectionTarget.preDestroy(instance);
        this.injectionTarget.dispose(instance);
        context.release();
    }

    @Override
    public Set<Type> getTypes() {
        Set<Type> contracts = super.getTypes();
        contracts.addAll(Arrays.asList(this.binding.getService().getInterfaces()));
        return contracts;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.binding.getService();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionTarget.getInjectionPoints();
    }

    void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    private static boolean isResourceClass(Class<?> clazz) {
        if (ClassBean.isJaxrsResource(clazz)) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!ClassBean.isJaxrsResource(iface)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJaxrsResource(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }
}

