/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.injector;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.InjectionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.glassfish.jersey.inject.cdi.se.injector.AbstractInjectionTarget;
import org.glassfish.jersey.inject.cdi.se.injector.JerseyInstanceInjector;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

public class WrappingJerseyInjectionTarget<T>
extends AbstractInjectionTarget<T> {
    private static InjectionTarget NOOP_INJECTION_TARGET = new NoOpInjectionTarget();
    private final Bean<T> bean;
    private final LazyValue<JerseyInstanceInjector<T>> injector;
    private final InjectionTarget<T> delegate;
    private Collection<InjectionResolver> resolvers;

    public WrappingJerseyInjectionTarget(Bean<T> bean, Collection<InjectionResolver> resolvers) {
        this(NOOP_INJECTION_TARGET, bean, resolvers);
    }

    public WrappingJerseyInjectionTarget(InjectionTarget<T> delegate, Bean<T> bean, Collection<InjectionResolver> resolvers) {
        this.bean = bean;
        this.delegate = delegate;
        this.resolvers = resolvers;
        this.injector = Values.lazy(() -> new JerseyInstanceInjector(bean, this.resolvers));
    }

    @Override
    public void inject(T instance, CreationalContext<T> ctx) {
        try {
            ((JerseyInstanceInjector)this.injector.get()).inject(instance);
        }
        catch (Throwable cause) {
            throw new InjectionException("Exception occurred during Jersey/JAX-RS annotations processing in the class: " + this.bean.getBeanClass(), cause);
        }
        super.inject(instance, ctx);
    }

    @Override
    InjectionTarget<T> delegate() {
        return this.delegate;
    }

    private static class NoOpInjectionTarget
    implements InjectionTarget<Object> {
        private NoOpInjectionTarget() {
        }

        public void inject(Object instance, CreationalContext<Object> ctx) {
        }

        public void postConstruct(Object instance) {
        }

        public void preDestroy(Object instance) {
        }

        public Object produce(CreationalContext<Object> ctx) {
            return null;
        }

        public void dispose(Object instance) {
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }
    }
}

