/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.Unmanaged;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.glassfish.jersey.inject.cdi.se.LocalizationMessages;
import org.glassfish.jersey.inject.cdi.se.SeBeanRegisterExtension;
import org.glassfish.jersey.inject.cdi.se.bean.JerseyBean;
import org.glassfish.jersey.inject.cdi.se.injector.ContextInjectionResolverImpl;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;

public class CdiSeInjectionManager
implements InjectionManager {
    private final AbstractBinder bindings = new AbstractBinder(){

        protected void configure() {
        }
    };
    private SeContainer container;
    private BeanManager beanManager;

    public void register(Binding binding) {
        this.bindings.bind(binding);
    }

    public void register(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            this.bindings.bind(binding);
        }
    }

    public void register(Binder binder) {
        for (Binding binding : Bindings.getBindings((InjectionManager)this, (Binder)binder)) {
            this.bindings.bind(binding);
        }
    }

    public void register(Object provider) throws IllegalArgumentException {
        throw new IllegalArgumentException(LocalizationMessages.CDI_2_PROVIDER_NOT_REGISTRABLE(provider.getClass()));
    }

    public boolean isRegistrable(Class<?> clazz) {
        return false;
    }

    public <T> T createAndInitialize(Class<T> createMe) {
        if (this.isInitialized()) {
            Unmanaged.UnmanagedInstance unmanaged = new Unmanaged(createMe).newInstance();
            return (T)unmanaged.produce().inject().postConstruct().get();
        }
        try {
            Constructor<T> constructor = createMe.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create an instance of a class: " + createMe, e);
        }
    }

    public <T> T create(Class<T> createMe) {
        if (this.isInitialized()) {
            Unmanaged.UnmanagedInstance unmanaged = new Unmanaged(createMe).newInstance();
            return (T)unmanaged.produce().get();
        }
        try {
            Constructor<T> constructor = createMe.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create an instance of a class: " + createMe, e);
        }
    }

    public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
        ArrayList<ServiceHolder<T>> result = new ArrayList<ServiceHolder<T>>();
        for (Bean bean : this.beanManager.getBeans(contractOrImpl, qualifiers)) {
            CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
            Object reference = this.beanManager.getReference(bean, contractOrImpl, ctx);
            int rank = 1;
            if (bean instanceof JerseyBean) {
                rank = ((JerseyBean)bean).getRank();
            }
            result.add((ServiceHolder<T>)new ServiceHolderImpl(reference, bean.getBeanClass(), bean.getTypes(), rank));
        }
        return result;
    }

    public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
        return this.getInstanceInternal(contractOrImpl, qualifiers);
    }

    public <T> T getInstance(Class<T> contractOrImpl) {
        return this.getInstanceInternal(contractOrImpl, new Annotation[0]);
    }

    public <T> T getInstance(Type contractOrImpl) {
        return this.getInstanceInternal(contractOrImpl, new Annotation[0]);
    }

    private <T> T getInstanceInternal(Type contractOrImpl, Annotation ... qualifiers) {
        Set beans;
        Set set = beans = this.isInitialized() ? this.beanManager.getBeans(contractOrImpl, qualifiers) : Collections.emptySet();
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, contractOrImpl, ctx);
    }

    private boolean isInitialized() {
        return this.container != null && this.beanManager != null;
    }

    public Object getInstance(ForeignDescriptor foreignDescriptor) {
        Bean bean = (Bean)foreignDescriptor.get();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return bean.create(ctx);
    }

    public ForeignDescriptor createForeignDescriptor(Binding binding) {
        Class<?> clazz;
        if (ClassBinding.class.isAssignableFrom(binding.getClass())) {
            clazz = ((ClassBinding)binding).getService();
        } else if (InstanceBinding.class.isAssignableFrom(binding.getClass())) {
            clazz = ((InstanceBinding)binding).getService().getClass();
        } else {
            throw new RuntimeException(org.glassfish.jersey.internal.LocalizationMessages.UNKNOWN_DESCRIPTOR_TYPE((Object)binding.getClass().getSimpleName()));
        }
        Set beans = this.beanManager.getBeans(clazz, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return ForeignDescriptor.wrap((Object)bean, instance -> bean.destroy(instance, ctx));
    }

    public <T> List<T> getAllInstances(Type contractOrImpl) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Bean bean : this.beanManager.getBeans(contractOrImpl, new Annotation[0])) {
            CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
            Object reference = this.beanManager.getReference(bean, contractOrImpl, ctx);
            result.add(reference);
        }
        return result;
    }

    public void inject(Object instance) {
        if (this.isInitialized()) {
            CreationalContext context = this.beanManager.createCreationalContext(null);
            AnnotatedType annotatedType = this.beanManager.createAnnotatedType(instance.getClass());
            InjectionTargetFactory injectionTargetFactory = this.beanManager.getInjectionTargetFactory(annotatedType);
            InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
            injectionTarget.inject(instance, context);
        }
    }

    public void preDestroy(Object preDestroyMe) {
        this.container.destroy(preDestroyMe);
    }

    public void completeRegistration() throws IllegalStateException {
        this.bindings.bind(Bindings.service((Object)this).to(InjectionManager.class));
        this.bindings.install(new AbstractBinder[]{new ContextInjectionResolverImpl.Binder(this::getBeanManager)});
        SeContainerInitializer containerInitializer = SeContainerInitializer.newInstance();
        containerInitializer.addExtensions(new Extension[]{new SeBeanRegisterExtension(this.bindings)});
        this.container = containerInitializer.initialize();
        this.beanManager = this.container.getBeanManager();
    }

    protected AbstractBinder getBindings() {
        return this.bindings;
    }

    public SeContainer getContainer() {
        return this.container;
    }

    public void setContainer(SeContainer container) {
        this.container = container;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public void shutdown() {
        if (this.container != null && this.container.isRunning()) {
            this.container.close();
        }
    }

    public void inject(Object injectMe, String classAnalyzer) {
        throw new UnsupportedOperationException();
    }

    public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
        throw new UnsupportedOperationException();
    }
}

