/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.glassfish.jersey.inject.cdi.se.bean.ClassBean;
import org.glassfish.jersey.inject.cdi.se.bean.InstanceBean;
import org.glassfish.jersey.inject.cdi.se.bean.SupplierBeanBridge;
import org.glassfish.jersey.inject.cdi.se.bean.SupplierClassBean;
import org.glassfish.jersey.inject.cdi.se.bean.SupplierInstanceBean;
import org.glassfish.jersey.inject.cdi.se.bean.SupplierInstanceBeanBridge;
import org.glassfish.jersey.inject.cdi.se.bean.SupplierThreadScopeBean;
import org.glassfish.jersey.inject.cdi.se.injector.CachedConstructorAnalyzer;
import org.glassfish.jersey.inject.cdi.se.injector.InjectionUtils;
import org.glassfish.jersey.inject.cdi.se.injector.JerseyConstructorInjectionPoint;
import org.glassfish.jersey.inject.cdi.se.injector.JerseyInjectionTarget;
import org.glassfish.jersey.inject.cdi.se.injector.WrappingJerseyInjectionTarget;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.SupplierClassBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.PerThread;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.ConstructorSignatureImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class BeanHelper {
    private BeanHelper() {
    }

    public static <T> void registerBean(InstanceBinding<T> binding, AfterBeanDiscovery abd, List<InjectionResolver> resolvers) {
        InstanceBean<T> bean = new InstanceBean<T>(binding);
        WrappingJerseyInjectionTarget<T> injectionTarget = new WrappingJerseyInjectionTarget<T>(bean, resolvers);
        bean.setInjectionTarget(injectionTarget);
        abd.addBean(bean);
    }

    public static <T> void registerBean(ClassBinding<T> binding, AfterBeanDiscovery abd, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(binding.getService());
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
        ClassBean<T> bean = new ClassBean<T>(binding);
        bean.setInjectionTarget(BeanHelper.getJerseyInjectionTarget(binding.getService(), injectionTarget, bean, resolvers));
        abd.addBean(bean);
    }

    public static <T> void registerSupplier(SupplierInstanceBinding<T> binding, AfterBeanDiscovery abd, BeanManager beanManager) {
        BeanManagerImpl manager = beanManager instanceof BeanManagerProxy ? ((BeanManagerProxy)beanManager).unwrap() : (BeanManagerImpl)beanManager;
        if (binding.getScope() == PerThread.class) {
            abd.addBean((Bean)new SupplierThreadScopeBean(binding, manager));
        } else {
            abd.addBean(new SupplierInstanceBean<T>(binding));
            abd.addBean(new SupplierInstanceBeanBridge(binding));
        }
    }

    public static <T> void registerSupplier(SupplierClassBinding<T> binding, AfterBeanDiscovery abd, Collection<InjectionResolver> resolvers, BeanManager beanManager) {
        Class supplierClass = binding.getSupplierClass();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(supplierClass);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget injectionTarget = injectionTargetFactory.createInjectionTarget(null);
        SupplierClassBean<T> supplierBean = new SupplierClassBean<T>(binding);
        InjectionTarget<T> jit = BeanHelper.getJerseyInjectionTarget(supplierClass, injectionTarget, supplierBean, resolvers);
        supplierBean.setInjectionTarget(jit);
        abd.addBean(supplierBean);
        abd.addBean((Bean)new SupplierBeanBridge(binding, beanManager));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> InjectionTarget<T> getJerseyInjectionTarget(Class<T> clazz, InjectionTarget<T> injectionTarget, Bean<T> bean, Collection<InjectionResolver> resolvers) {
        JerseyInjectionTarget<T> jit;
        BasicInjectionTarget it = (BasicInjectionTarget)injectionTarget;
        boolean noArgConstructor = BeanHelper.isNoArgConstructorCase(it, clazz);
        if (!noArgConstructor && injectionTarget instanceof BeanInjectionTarget) {
            jit = new JerseyInjectionTarget<T>(it, bean, clazz, resolvers);
        } else {
            if (!noArgConstructor && !(injectionTarget instanceof NonProducibleInjectionTarget)) throw new RuntimeException("Unknown InjectionTarget for the class: " + clazz.getTypeName());
            CachedConstructorAnalyzer<T> analyzer = new CachedConstructorAnalyzer<T>(clazz, InjectionUtils.getInjectAnnotations(resolvers));
            if (!analyzer.hasCompatibleConstructor()) return new WrappingJerseyInjectionTarget<T>(it, bean, resolvers);
            EnhancedAnnotatedConstructor constructor = BeanHelper.createEnhancedAnnotatedType(it).getDeclaredEnhancedConstructor((ConstructorSignature)new ConstructorSignatureImpl(analyzer.getConstructor()));
            JerseyConstructorInjectionPoint<T> constructorInjectionPoint = new JerseyConstructorInjectionPoint<T>(constructor, bean, it.getBeanManager(), resolvers);
            JerseyInstantiator<T> instantiator = new JerseyInstantiator<T>(constructorInjectionPoint);
            jit = new JerseyInjectionTarget<T>(BeanHelper.createEnhancedAnnotatedType(it), it, bean, clazz, resolvers, instantiator);
        }
        InjectionTargetService injectionTargetService = (InjectionTargetService)it.getBeanManager().getServices().get(InjectionTargetService.class);
        injectionTargetService.addInjectionTargetToBeInitialized(jit.getEnhancedAnnotatedType(), jit);
        return jit;
    }

    public static <T> EnhancedAnnotatedType<T> createEnhancedAnnotatedType(BasicInjectionTarget<T> it) {
        return EnhancedAnnotatedTypeImpl.of((SlimAnnotatedType)((SlimAnnotatedType)it.getAnnotatedType()), (ClassTransformer)ClassTransformer.instance((BeanManagerImpl)it.getBeanManager()));
    }

    private static <T> boolean isNoArgConstructorCase(BasicInjectionTarget<T> it, Class<T> clazz) {
        if (!(it instanceof NonProducibleInjectionTarget)) {
            Instantiator instantiator = it.getInstantiator();
            Constructor constructor = instantiator.getConstructor();
            return constructor.getParameterCount() == 0 && clazz.getConstructors().length > 1;
        }
        return false;
    }

    private static class JerseyInstantiator<T>
    extends AbstractInstantiator<T> {
        private final ConstructorInjectionPoint<T> injectionPoint;

        private JerseyInstantiator(ConstructorInjectionPoint<T> injectionPoint) {
            this.injectionPoint = injectionPoint;
        }

        public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
            return this.injectionPoint;
        }

        public Constructor<T> getConstructor() {
            return this.injectionPoint.getAnnotated().getJavaMember();
        }

        public String toString() {
            return "JerseyInstantiator [constructor=" + this.injectionPoint.getMember() + "]";
        }

        public boolean hasInterceptorSupport() {
            return false;
        }

        public boolean hasDecoratorSupport() {
            return false;
        }
    }
}

