/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionManagerFactory;

public class Injections {
    public static InjectionManager createInjectionManager() {
        return Injections.lookupInjectionManagerFactory().create();
    }

    public static InjectionManager createInjectionManager(Binder binder) {
        InjectionManagerFactory injectionManagerFactory = Injections.lookupInjectionManagerFactory();
        InjectionManager injectionManager = injectionManagerFactory.create();
        injectionManager.register(binder);
        return injectionManager;
    }

    public static InjectionManager createInjectionManager(Object parent) {
        return Injections.lookupInjectionManagerFactory().create(parent);
    }

    private static InjectionManagerFactory lookupInjectionManagerFactory() {
        Iterator<InjectionManagerFactory> iterator = ServiceFinder.find(InjectionManagerFactory.class).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new IllegalStateException(LocalizationMessages.INJECTION_MANAGER_FACTORY_NOT_FOUND());
    }

    public static <T> T getOrCreate(InjectionManager injectionManager, Class<T> clazz) {
        try {
            T component = injectionManager.getInstance(clazz);
            return component == null ? injectionManager.createAndInitialize(clazz) : component;
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable != null && WebApplicationException.class.isAssignableFrom(throwable.getClass())) {
                throw (WebApplicationException)throwable;
            }
            throw e;
        }
    }
}

