/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.Stage;

class ClientFilteringStages {
    private ClientFilteringStages() {
    }

    static ChainableStage<ClientRequest> createRequestFilteringStage(ServiceLocator locator) {
        List<ClientRequestFilter> requestFilters = Providers.getAllProviders(locator, ClientRequestFilter.class, new PriorityComparator(PriorityComparator.Order.ASCENDING));
        return !requestFilters.isEmpty() ? new RequestFilteringStage(requestFilters) : null;
    }

    static ChainableStage<ClientResponse> createResponseFilteringStage(ServiceLocator locator) {
        List<ClientResponseFilter> responseFilters = Providers.getAllProviders(locator, ClientResponseFilter.class, new PriorityComparator(PriorityComparator.Order.DESCENDING));
        return !responseFilters.isEmpty() ? new ResponseFilterStage(responseFilters) : null;
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ClientResponse> {
        private final List<ClientResponseFilter> filters;

        private ResponseFilterStage(List<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        @Override
        public Stage.Continuation<ClientResponse> apply(ClientResponse responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter(responseContext.getRequestContext(), responseContext);
                }
            }
            catch (IOException ex) {
                throw new ClientException(ex);
            }
            return Stage.Continuation.of(responseContext, this.getDefaultNext());
        }
    }

    private static final class RequestFilteringStage
    extends AbstractChainableStage<ClientRequest> {
        private final List<ClientRequestFilter> requestFilters;

        private RequestFilteringStage(List<ClientRequestFilter> requestFilters) {
            this.requestFilters = requestFilters;
        }

        @Override
        public Stage.Continuation<ClientRequest> apply(ClientRequest requestContext) {
            for (ClientRequestFilter filter : this.requestFilters) {
                try {
                    filter.filter(requestContext);
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    throw new AbortException(new ClientResponse(requestContext, abortResponse));
                }
                catch (IOException ex) {
                    throw new ClientException(ex);
                }
            }
            return Stage.Continuation.of(requestContext, this.getDefaultNext());
        }
    }
}

