/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.jersey.internal.inject.AbstractBindingBuilder;
import org.glassfish.jersey.internal.inject.BindingBuilder;
import org.glassfish.jersey.internal.inject.ScopedBindingBuilder;
import org.glassfish.jersey.internal.inject.ServiceBindingBuilder;
import org.jvnet.hk2.external.generator.ServiceLocatorGeneratorImpl;

public class Injections {
    private static final ServiceLocatorGenerator generator = new ServiceLocatorGeneratorImpl();
    private static final ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();

    public static DynamicConfiguration getConfiguration(ServiceLocator locator) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        return dcs.createDynamicConfiguration();
    }

    public static ServiceLocator createLocator(String name, ServiceLocator parent, Binder ... binders) {
        ServiceLocator locator = factory.create(name, parent, generator);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)locator);
        for (Binder binder : binders) {
            Injections.bind(locator, binder);
        }
        return locator;
    }

    public static ServiceLocator createLocator(String name, Binder ... binders) {
        ServiceLocator locator = factory.create(name, null, generator);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)locator);
        for (Binder binder : binders) {
            Injections.bind(locator, binder);
        }
        return locator;
    }

    public static ServiceLocator createLocator(ServiceLocator parent, Binder ... binders) {
        ServiceLocator locator = factory.create(null, parent, generator);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)locator);
        for (Binder binder : binders) {
            Injections.bind(locator, binder);
        }
        return locator;
    }

    public static ServiceLocator createLocator(Binder ... binders) {
        ServiceLocator locator = factory.create(null, null, generator);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)locator);
        for (Binder binder : binders) {
            Injections.bind(locator, binder);
        }
        return locator;
    }

    private static void bind(ServiceLocator locator, Binder binder) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        locator.inject((Object)binder);
        binder.bind(dc);
        dc.commit();
    }

    public static <T> T getOrCreate(ServiceLocator serviceLocator, Class<T> clazz) {
        Object component = serviceLocator.getService(clazz, new Annotation[0]);
        return (T)(component == null ? serviceLocator.createAndInitialize(clazz) : component);
    }

    public static void addBinding(BindingBuilder<?> builder, DynamicConfiguration configuration) {
        if (!(builder instanceof AbstractBindingBuilder)) {
            throw new IllegalArgumentException("Unknown binding builder type: " + builder.getClass().getName());
        }
        ((AbstractBindingBuilder)builder).complete(configuration, null);
    }

    public static void addBinding(BindingBuilder<?> builder, DynamicConfiguration configuration, HK2Loader defaultLoader) {
        if (!(builder instanceof AbstractBindingBuilder)) {
            throw new IllegalArgumentException("Unknown binding builder type: " + builder.getClass().getName());
        }
        ((AbstractBindingBuilder)builder).complete(configuration, defaultLoader);
    }

    public static <T> ServiceBindingBuilder<T> newFactoryBinder(Class<? extends Factory<T>> factoryType, Class<? extends Annotation> factoryScope) {
        return AbstractBindingBuilder.createFactoryBinder(factoryType, factoryScope);
    }

    public static <T> ServiceBindingBuilder<T> newFactoryBinder(Class<? extends Factory<T>> factoryType) {
        return AbstractBindingBuilder.createFactoryBinder(factoryType, null);
    }

    public static <T> ServiceBindingBuilder<T> newFactoryBinder(Factory<T> factory) {
        return AbstractBindingBuilder.createFactoryBinder(factory);
    }

    public static <T> ServiceBindingBuilder<T> newBinder(Class<T> serviceType) {
        return AbstractBindingBuilder.create(serviceType, false);
    }

    public static <T> ScopedBindingBuilder<T> newBinder(T service) {
        return AbstractBindingBuilder.create(service);
    }
}

