/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.internal.inject.AbstractStringReaderExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.spi.StringValueReader;

abstract class CollectionExtractor<T>
extends AbstractStringReaderExtractor<T>
implements MultivaluedParameterExtractor<Collection<T>> {
    protected CollectionExtractor(StringValueReader<T> sr, String parameter, String defaultStringValue) {
        super(sr, parameter, defaultStringValue);
    }

    @Override
    public Collection<T> extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get(this.getName());
        Collection<T> valueList = this.getInstance();
        if (stringList != null) {
            for (String v : stringList) {
                valueList.add(this.fromString(v));
            }
        } else if (this.isDefaultValueRegistered()) {
            valueList.add(this.defaultValue());
        }
        return valueList;
    }

    protected abstract Collection<T> getInstance();

    public static <T> MultivaluedParameterExtractor getInstance(Class<?> c, StringValueReader<T> sr, String parameter, String defaultValueString) {
        if (List.class == c) {
            return new ListValueOf<T>(sr, parameter, defaultValueString);
        }
        if (Set.class == c) {
            return new SetValueOf<T>(sr, parameter, defaultValueString);
        }
        if (SortedSet.class == c) {
            return new SortedSetValueOf<T>(sr, parameter, defaultValueString);
        }
        throw new RuntimeException();
    }

    private static final class SortedSetValueOf<T>
    extends CollectionExtractor<T> {
        SortedSetValueOf(StringValueReader<T> sr, String parameter, String defaultValueString) {
            super(sr, parameter, defaultValueString);
        }

        @Override
        protected SortedSet<T> getInstance() {
            return new TreeSet();
        }
    }

    private static final class SetValueOf<T>
    extends CollectionExtractor<T> {
        SetValueOf(StringValueReader<T> sr, String parameter, String defaultValueString) {
            super(sr, parameter, defaultValueString);
        }

        @Override
        protected Set<T> getInstance() {
            return new HashSet();
        }
    }

    private static final class ListValueOf<T>
    extends CollectionExtractor<T> {
        ListValueOf(StringValueReader<T> sr, String parameter, String defaultValueString) {
            super(sr, parameter, defaultValueString);
        }

        @Override
        protected List<T> getInstance() {
            return new ArrayList();
        }
    }
}

