/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.glassfish.jersey.message.internal.MessageBodyProcessingException;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
final class PrimitiveTypesMessageProvider
extends AbstractMessageReaderWriterProvider<Object> {
    PrimitiveTypesMessageProvider() {
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return PrimitiveTypes.forType(type) != null;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return PrimitiveTypes.forType(type).convert(PrimitiveTypesMessageProvider.readFromAsString(entityStream, mediaType));
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return PrimitiveTypes.forType(type) != null;
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.toString().length();
    }

    @Override
    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        PrimitiveTypesMessageProvider.writeToAsString(o.toString(), entityStream, mediaType);
    }

    private static enum PrimitiveTypes {
        BYTE((Class)Byte.class, (Class)Byte.TYPE){

            @Override
            public Object convert(String s) {
                return Byte.valueOf(s);
            }
        }
        ,
        SHORT((Class)Short.class, (Class)Short.TYPE){

            @Override
            public Object convert(String s) {
                return Short.valueOf(s);
            }
        }
        ,
        INTEGER((Class)Integer.class, (Class)Integer.TYPE){

            @Override
            public Object convert(String s) {
                return Integer.valueOf(s);
            }
        }
        ,
        LONG((Class)Long.class, (Class)Long.TYPE){

            @Override
            public Object convert(String s) {
                return Long.valueOf(s);
            }
        }
        ,
        FLOAT((Class)Float.class, (Class)Float.TYPE){

            @Override
            public Object convert(String s) {
                return Float.valueOf(s);
            }
        }
        ,
        DOUBLE((Class)Double.class, (Class)Double.TYPE){

            @Override
            public Object convert(String s) {
                return Double.valueOf(s);
            }
        }
        ,
        BOOLEAN((Class)Boolean.class, (Class)Boolean.TYPE){

            @Override
            public Object convert(String s) {
                return Boolean.valueOf(s);
            }
        }
        ,
        CHAR((Class)Character.class, (Class)Character.TYPE){

            @Override
            public Object convert(String s) {
                if (s.length() != 1) {
                    throw new MessageBodyProcessingException("A single character expected in the entity input stream.");
                }
                return Character.valueOf(s.charAt(0));
            }
        };

        private final Class<?> wrapper;
        private final Class<?> primitive;

        public static PrimitiveTypes forType(Class<?> type) {
            for (PrimitiveTypes primitive : PrimitiveTypes.values()) {
                if (!primitive.supports(type)) continue;
                return primitive;
            }
            return null;
        }

        private PrimitiveTypes(Class<?> wrapper, Class<?> primitive) {
            this.wrapper = wrapper;
            this.primitive = primitive;
        }

        public abstract Object convert(String var1);

        public boolean supports(Class<?> type) {
            return type == this.wrapper || type == this.primitive;
        }
    }
}

