/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Comparator;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.QualitySourceMediaType;

class CombinedClientServerMediaType {
    private MediaType combinedMediaType;
    private int q;
    private int qs;
    private int d;
    private static final CombinedClientServerMediaType NO_MATCH = new CombinedClientServerMediaType();
    private static final Comparator<MediaType> partialOrderComparator = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType o1, MediaType o2) {
            return CombinedClientServerMediaType.m2i(o2) - CombinedClientServerMediaType.m2i(o1);
        }
    };
    static final Comparator<CombinedClientServerMediaType> COMPARATOR = new Comparator<CombinedClientServerMediaType>(){

        @Override
        public int compare(CombinedClientServerMediaType c1, CombinedClientServerMediaType c2) {
            int partialComparison = partialOrderComparator.compare(c1.combinedMediaType, c2.combinedMediaType);
            if (partialComparison > 0) {
                return 1;
            }
            if (partialComparison == 0) {
                if (c1.q > c2.q) {
                    return 1;
                }
                if (c1.q == c2.q) {
                    if (c1.qs > c2.qs) {
                        return 1;
                    }
                    if (c1.qs == c2.qs) {
                        return c2.d - c1.d;
                    }
                }
            }
            return -1;
        }
    };

    private static int wildcardsMatched(MediaType clientMt, EffectiveMediaType serverMt) {
        return CombinedClientServerMediaType.b2i(clientMt.isWildcardType() ^ serverMt.isWildcardType()) + CombinedClientServerMediaType.b2i(clientMt.isWildcardSubtype() ^ serverMt.isWildcardSubType());
    }

    private static int b2i(boolean b) {
        return b ? 1 : 0;
    }

    private static int m2i(MediaType mt) {
        return 10 * CombinedClientServerMediaType.b2i(mt.isWildcardType()) + CombinedClientServerMediaType.b2i(mt.isWildcardSubtype());
    }

    private CombinedClientServerMediaType() {
    }

    public static CombinedClientServerMediaType create(MediaType clientMt, EffectiveMediaType serverMt) {
        if (!clientMt.isCompatible(serverMt.getMediaType())) {
            return NO_MATCH;
        }
        CombinedClientServerMediaType result = new CombinedClientServerMediaType();
        result.combinedMediaType = MediaTypes.stripQualityParams(MediaTypes.mostSpecific(clientMt, serverMt.getMediaType()));
        result.d = CombinedClientServerMediaType.wildcardsMatched(clientMt, serverMt);
        result.q = MediaTypes.getQuality(clientMt);
        result.qs = QualitySourceMediaType.getQualitySource(serverMt.getMediaType());
        return result;
    }

    public String toString() {
        return String.format("%s:%d:%d:%d", this.combinedMediaType, this.q, this.qs, this.d);
    }

    int getQ() {
        return this.q;
    }

    int getQs() {
        return this.qs;
    }

    int getD() {
        return this.d;
    }

    MediaType getCombinedMediaType() {
        return this.combinedMediaType;
    }

    static class EffectiveMediaType {
        private final boolean derived;
        private final MediaType mediaType;

        public EffectiveMediaType(MediaType mediaType, boolean fromMessageBodyProviders) {
            this.derived = fromMessageBodyProviders;
            this.mediaType = mediaType;
        }

        public EffectiveMediaType(String mediaTypeValue) {
            this(MediaType.valueOf(mediaTypeValue), false);
        }

        public EffectiveMediaType(MediaType mediaType) {
            this(mediaType, false);
        }

        public boolean isWildcardType() {
            if (this.mediaType.isWildcardType()) {
                return true;
            }
            return this.derived;
        }

        public boolean isWildcardSubType() {
            if (this.mediaType.isWildcardSubtype()) {
                return true;
            }
            return this.derived;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public String toString() {
            return String.format("mediaType=[%s], fromProviders=%b", this.mediaType, this.derived);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EffectiveMediaType)) {
                return false;
            }
            EffectiveMediaType that = (EffectiveMediaType)o;
            if (this.derived != that.derived) {
                return false;
            }
            return this.mediaType.equals(that.mediaType);
        }

        public int hashCode() {
            int result = this.derived ? 1 : 0;
            result = 31 * result + this.mediaType.hashCode();
            return result;
        }
    }
}

