/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.filter;

import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.spi.ContentEncoder;

public class EncodingFeature
implements Feature {
    private final String useEncoding;
    private final Class<? extends ContentEncoder>[] encodingProviders;

    public EncodingFeature(Class<? extends ContentEncoder> ... encodingProviders) {
        this((String)null, encodingProviders);
    }

    public EncodingFeature(String useEncoding, Class<? extends ContentEncoder> ... encoders) {
        this.useEncoding = useEncoding;
        this.encodingProviders = encoders;
    }

    @Override
    public boolean configure(Configurable configuration) {
        boolean enable;
        if (this.useEncoding != null && !configuration.getProperties().containsKey("jersey.config.client.useEncoding")) {
            configuration.setProperty("jersey.config.client.useEncoding", this.useEncoding);
        }
        for (Class<? extends ContentEncoder> provider : this.encodingProviders) {
            configuration.register(provider);
        }
        boolean bl = enable = this.useEncoding != null || this.encodingProviders.length > 0;
        if (enable) {
            configuration.register(EncodingFilter.class);
        }
        return enable;
    }
}

