/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.model.internal.DefaultConfig;
import org.glassfish.jersey.model.internal.FeatureBag;
import org.glassfish.jersey.model.internal.ProviderBag;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener;
import org.glassfish.jersey.server.internal.scanning.FilesScanner;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.model.Resource;

public class ResourceConfig
extends Application {
    private static final Logger LOGGER = Logger.getLogger(ResourceConfig.class.getName());
    private transient Set<Class<?>> cachedClasses = null;
    private transient Set<Class<?>> cachedClassesView = null;
    private transient Set<Object> cachedSingletons = null;
    private transient Set<Object> cachedSingletonsView = null;
    private final Set<Class<?>> classes;
    private final Set<Object> resourceSingletons;
    private final Set<ResourceFinder> resourceFinders;
    private final Set<Resource> resources;
    private final Set<Resource> resourcesView;
    private final Set<Binder> customBinders;
    private ClassLoader classLoader = null;
    private InternalState internalState = new Mutable();

    public ResourceConfig() {
        this.classLoader = ReflectionHelper.getContextClassLoader();
        this.classes = Sets.newHashSet();
        this.resourceSingletons = Sets.newHashSet();
        this.resources = Sets.newHashSet();
        this.resourcesView = Collections.unmodifiableSet(this.resources);
        this.resourceFinders = Sets.newHashSet();
        this.customBinders = Sets.newHashSet();
    }

    public ResourceConfig(Set<Class<?>> classes) {
        this();
        this.addClasses(classes);
    }

    public ResourceConfig(Class<?> ... classes) {
        this(Sets.newHashSet((Object[])classes));
    }

    public ResourceConfig(ResourceConfig original) {
        this.classLoader = original.classLoader;
        this.classes = Sets.newHashSet(original.classes);
        this.resourceSingletons = Sets.newHashSet(original.resourceSingletons);
        this.resources = Sets.newHashSet(original.resources);
        this.resourcesView = Collections.unmodifiableSet(this.resources);
        this.resourceFinders = Sets.newHashSet(original.resourceFinders);
        this.customBinders = Sets.newHashSet(original.customBinders);
        this.internalState = new Mutable((DefaultConfig)((Object)original.internalState));
    }

    public static ResourceConfig forApplication(Application application) {
        return application instanceof ResourceConfig ? (ResourceConfig)application : new WrappingResourceConfig(application, null, null);
    }

    static RuntimeResourceConfig newRuntimeResourceConfig(Application application) {
        RuntimeResourceConfig runtimeResourceConfig;
        if (application instanceof ResourceConfig) {
            ResourceConfig resourceConfig = (ResourceConfig)application;
            runtimeResourceConfig = new RuntimeResourceConfig(resourceConfig);
            application = resourceConfig.getApplication();
        } else {
            runtimeResourceConfig = new RuntimeResourceConfig();
        }
        if (application != null) {
            Set<Object> singletons;
            Set<Class<?>> classes = application.getClasses();
            if (classes != null) {
                runtimeResourceConfig.classes.addAll(classes);
            }
            if ((singletons = application.getSingletons()) != null) {
                runtimeResourceConfig.resourceSingletons.addAll(singletons);
            }
        }
        return runtimeResourceConfig;
    }

    public static ResourceConfig forApplicationClass(Class<? extends Application> applicationClass) {
        return new WrappingResourceConfig(null, applicationClass, null);
    }

    public static ResourceConfig forApplicationClass(Class<? extends Application> applicationClass, Set<Class<?>> defaultClasses) {
        return new WrappingResourceConfig(null, applicationClass, defaultClasses);
    }

    public final ResourceConfig addClasses(Set<Class<?>> classes) {
        return this.internalState.addClasses(classes);
    }

    public final ResourceConfig addClasses(Class<?> ... classes) {
        return this.addClasses(Sets.newHashSet((Object[])classes));
    }

    public final ResourceConfig addSingletons(Set<Object> singletons) {
        return this.internalState.addSingletons(singletons);
    }

    public final ResourceConfig addSingletons(Object ... singletons) {
        return this.addSingletons(Sets.newHashSet((Object[])singletons));
    }

    public final ResourceConfig addResources(Resource ... resources) {
        return this.addResources(Sets.newHashSet((Object[])resources));
    }

    public final ResourceConfig addResources(Set<Resource> resources) {
        return this.internalState.addResources(resources);
    }

    public ResourceConfig setProperty(String name, Object value) {
        this.internalState.setProperty(name, value);
        return this;
    }

    public ResourceConfig setProperties(Map<String, ?> properties) {
        this.internalState.setProperties(properties);
        return this;
    }

    public Collection<Feature> getFeatures() {
        return this.internalState.getFeatures();
    }

    public Set<Class<?>> getProviderClasses() {
        return this.internalState.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.internalState.getProviderInstances();
    }

    public ResourceConfig register(Class<?> providerClass) {
        this.internalState.register(providerClass);
        return this;
    }

    public ResourceConfig register(Object provider) {
        this.internalState.register(provider);
        return this;
    }

    public ResourceConfig register(Class<?> providerClass, int bindingPriority) {
        this.internalState.register(providerClass, bindingPriority);
        return this;
    }

    public <T> ResourceConfig register(Class<T> providerClass, Class<? super T> ... contracts) {
        this.internalState.register(providerClass, contracts);
        return this;
    }

    public <T> ResourceConfig register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
        this.internalState.register(providerClass, bindingPriority, contracts);
        return this;
    }

    public ResourceConfig register(Object provider, int bindingPriority) {
        this.internalState.register(provider, bindingPriority);
        return this;
    }

    public <T> ResourceConfig register(Object provider, Class<? super T> ... contracts) {
        this.internalState.register(provider, contracts);
        return this;
    }

    public <T> ResourceConfig register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
        this.internalState.register(provider, bindingPriority, contracts);
        return this;
    }

    ProviderBag getProviderBag() {
        return ((DefaultConfig)((Object)this.internalState)).getProviderBag();
    }

    FeatureBag getFeatureBag() {
        return ((DefaultConfig)((Object)this.internalState)).getFeatureBag();
    }

    public final ResourceConfig addProperties(Map<String, Object> properties) {
        return this.internalState.addProperties(properties);
    }

    public final ResourceConfig addFinder(ResourceFinder resourceFinder) {
        return this.internalState.addFinder(resourceFinder);
    }

    public final ResourceConfig addBinders(Set<Binder> binders) {
        return this.internalState.addBinders(binders);
    }

    public final ResourceConfig addBinders(Binder ... binders) {
        return this.addBinders(Sets.newHashSet((Object[])binders));
    }

    public final ResourceConfig setClassLoader(ClassLoader classLoader) {
        return this.internalState.setClassLoader(classLoader);
    }

    public final ResourceConfig packages(String ... packages) {
        return this.addFinder(new PackageNamesScanner(packages));
    }

    public final ResourceConfig files(String ... files) {
        return this.addFinder(new FilesScanner(files));
    }

    private void invalidateCache() {
        this.cachedClasses = null;
        this.cachedClassesView = null;
        this.cachedSingletons = null;
        this.cachedSingletonsView = null;
    }

    final Set<Binder> getCustomBinders() {
        return this.customBinders;
    }

    void lock() {
        if (!(this.internalState instanceof Immutable)) {
            this.internalState = new Immutable((DefaultConfig)((Object)this.internalState));
        }
    }

    @Override
    public final Set<Class<?>> getClasses() {
        if (this.cachedClassesView == null) {
            this.cachedClasses = this._getClasses();
            this.cachedClassesView = Collections.unmodifiableSet(this.cachedClasses);
        }
        return this.cachedClassesView;
    }

    Set<Class<?>> _getClasses() {
        String[] classPathElements;
        String[] packageNames;
        HashSet result = Sets.newHashSet();
        HashSet rfs = Sets.newHashSet(this.resourceFinders);
        String[] classNames = this.parsePropertyValue("jersey.config.server.provider.classnames");
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    result.add(this.classLoader.loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.CONFIG, LocalizationMessages.UNABLE_TO_LOAD_CLASS(className));
                }
            }
        }
        if ((packageNames = this.parsePropertyValue("jersey.config.server.provider.packages")) != null) {
            rfs.add(new PackageNamesScanner(packageNames));
        }
        if ((classPathElements = this.parsePropertyValue("jersey.config.server.provider.classpath")) != null) {
            rfs.add(new FilesScanner(classPathElements));
        }
        AnnotationAcceptingListener afl = AnnotationAcceptingListener.newJaxrsResourceAndProviderListener(this.classLoader);
        for (ResourceFinder resourceFinder : rfs) {
            while (resourceFinder.hasNext()) {
                String next = (String)resourceFinder.next();
                if (!afl.accept(next)) continue;
                try {
                    afl.process(next, resourceFinder.open());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Unable to process {0}", next);
                }
            }
        }
        result.addAll(afl.getAnnotatedClasses());
        result.addAll(this.internalState.getProviderClasses());
        result.addAll(this.classes);
        return result;
    }

    private String[] parsePropertyValue(String propertyName) {
        String[] classNames = null;
        Object o = this.internalState.getProperties().get(propertyName);
        if (o != null) {
            if (o instanceof String) {
                classNames = Tokenizer.tokenize((String)o);
            } else if (o instanceof String[]) {
                classNames = Tokenizer.tokenize((String[])o);
            }
        }
        return classNames;
    }

    public Set<Class<?>> getRegisteredClasses() {
        return this.classes;
    }

    @Override
    public final Set<Object> getSingletons() {
        if (this.cachedSingletonsView == null) {
            this.cachedSingletons = this._getSingletons();
            this.cachedSingletonsView = Collections.unmodifiableSet(this.cachedSingletons == null ? new HashSet() : this.cachedSingletons);
        }
        return this.cachedSingletonsView;
    }

    Set<Object> _getSingletons() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.internalState.getProviderInstances());
        result.addAll(this.resourceSingletons);
        return result;
    }

    public final Set<Resource> getResources() {
        return this.resourcesView;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final Map<String, Object> getProperties() {
        return this.internalState.getProperties();
    }

    public final Object getProperty(String name) {
        return this.internalState.getProperty(name);
    }

    public final boolean isProperty(String name) {
        return PropertiesHelper.isProperty(this.internalState.getProperties(), name);
    }

    public final Application getApplication() {
        return this._getApplication();
    }

    Application _getApplication() {
        return this;
    }

    Class<? extends Application> getApplicationClass() {
        return null;
    }

    final ResourceConfig setApplication(Application app) {
        this.internalState.setApplication(app);
        return this;
    }

    ResourceConfig _setApplication(Application app) {
        throw new UnsupportedOperationException();
    }

    private static class WrappingResourceConfig
    extends ResourceConfig {
        private Application application;
        private Class<? extends Application> applicationClass;
        private final Set<Class<?>> defaultClasses = Sets.newHashSet();

        public WrappingResourceConfig(Application application, Class<? extends Application> applicationClass, Set<Class<?>> defaultClasses) {
            if (application == null && applicationClass == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESOURCE_CONFIG_ERROR_NULL_APPLICATIONCLASS());
            }
            this.application = application;
            this.applicationClass = applicationClass;
            if (defaultClasses != null) {
                this.defaultClasses.addAll(defaultClasses);
            }
            this.mergeApplications(application);
        }

        @Override
        ResourceConfig _setApplication(Application application) {
            this.application = application;
            this.applicationClass = null;
            this.mergeApplications(application);
            return this;
        }

        @Override
        Application _getApplication() {
            return this.application;
        }

        @Override
        Class<? extends Application> getApplicationClass() {
            return this.applicationClass;
        }

        private void mergeApplications(Application application) {
            if (application instanceof ResourceConfig) {
                ResourceConfig rc = (ResourceConfig)application;
                ((ResourceConfig)this).customBinders.addAll(rc.customBinders);
                ((ResourceConfig)this).resources.addAll(rc.resources);
                rc.invalidateCache();
                rc.internalState.addProperties(super.getProperties());
                super.addProperties(rc.getProperties());
                rc.lock();
            }
        }

        @Override
        Set<Class<?>> _getClasses() {
            HashSet result = Sets.newHashSet();
            HashSet applicationClasses = this.application.getClasses();
            result.addAll(applicationClasses == null ? new HashSet() : applicationClasses);
            if (result.isEmpty() && this.getSingletons().isEmpty()) {
                result.addAll(this.defaultClasses);
            }
            if (!(this.application instanceof ResourceConfig)) {
                result.addAll(super._getClasses());
            }
            return result;
        }

        @Override
        Set<Object> _getSingletons() {
            return this.application.getSingletons();
        }
    }

    static class RuntimeResourceConfig
    extends ResourceConfig
    implements Configurable {
        public RuntimeResourceConfig() {
        }

        public RuntimeResourceConfig(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        public RuntimeResourceConfig setProperties(Map<String, ?> properties) {
            super.setProperties(properties);
            return this;
        }

        @Override
        public RuntimeResourceConfig setProperty(String name, Object value) {
            super.setProperty(name, value);
            return this;
        }

        @Override
        public RuntimeResourceConfig register(Class<?> providerClass) {
            super.register(providerClass);
            return this;
        }

        @Override
        public RuntimeResourceConfig register(Class<?> providerClass, int bindingPriority) {
            super.register(providerClass, bindingPriority);
            return this;
        }

        @Override
        public <T> RuntimeResourceConfig register(Class<T> providerClass, Class<? super T> ... contracts) {
            super.register(providerClass, contracts);
            return this;
        }

        @Override
        public <T> RuntimeResourceConfig register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
            super.register(providerClass, bindingPriority, contracts);
            return this;
        }

        @Override
        public RuntimeResourceConfig register(Object provider) {
            super.register(provider);
            return this;
        }

        @Override
        public RuntimeResourceConfig register(Object provider, int bindingPriority) {
            super.register(provider, bindingPriority);
            return this;
        }

        @Override
        public <T> RuntimeResourceConfig register(Object provider, Class<? super T> ... contracts) {
            super.register(provider, contracts);
            return this;
        }

        @Override
        public <T> RuntimeResourceConfig register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
            super.register(provider, bindingPriority, contracts);
            return this;
        }
    }

    private class Mutable
    extends DefaultConfig
    implements InternalState {
        private Mutable() {
        }

        private Mutable(DefaultConfig config) {
            super(config);
        }

        @Override
        public ResourceConfig addClasses(Set<Class<?>> classes) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.classes.addAll(classes);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addResources(Set<Resource> resources) {
            ResourceConfig.this.resources.addAll(resources);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addFinder(ResourceFinder resourceFinder) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.resourceFinders.add(resourceFinder);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addBinders(Set<Binder> binders) {
            ResourceConfig.this.customBinders.addAll(binders);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addProperties(Map<String, Object> properties) {
            ResourceConfig.this.invalidateCache();
            HashMap props = Maps.newHashMap(this.getProperties());
            props.putAll(properties);
            this.setProperties((Map)properties);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addSingletons(Set<Object> singletons) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.resourceSingletons.addAll(singletons);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig setClassLoader(ClassLoader classLoader) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.classLoader = classLoader;
            return ResourceConfig.this;
        }

        @Override
        public Mutable setProperty(String name, Object value) {
            ResourceConfig.this.invalidateCache();
            super.setProperty(name, value);
            return this;
        }

        @Override
        public Mutable setProperties(Map<String, ?> properties) {
            ResourceConfig.this.invalidateCache();
            super.setProperties(properties);
            return this;
        }

        @Override
        public Mutable register(Class<?> providerClass) {
            ResourceConfig.this.invalidateCache();
            super.register(providerClass);
            return this;
        }

        @Override
        public Mutable register(Class<?> providerClass, int bindingPriority) {
            ResourceConfig.this.invalidateCache();
            super.register(providerClass, bindingPriority);
            return this;
        }

        @Override
        public <T> Mutable register(Class<T> providerClass, Class<? super T> ... contracts) {
            ResourceConfig.this.invalidateCache();
            super.register(providerClass, (Class<? super P>[])contracts);
            return this;
        }

        @Override
        public <T> Mutable register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
            ResourceConfig.this.invalidateCache();
            super.register(providerClass, bindingPriority, (Class<? super P>[])contracts);
            return this;
        }

        @Override
        public Mutable register(Object provider) {
            ResourceConfig.this.invalidateCache();
            super.register(provider);
            return this;
        }

        @Override
        public Mutable register(Object provider, int bindingPriority) {
            ResourceConfig.this.invalidateCache();
            super.register(provider, bindingPriority);
            return this;
        }

        @Override
        public <T> Mutable register(Object provider, Class<? super T> ... contracts) {
            ResourceConfig.this.invalidateCache();
            super.register(provider, (Class<? super P>[])contracts);
            return this;
        }

        @Override
        public <T> Mutable register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
            ResourceConfig.this.invalidateCache();
            super.register(provider, bindingPriority, (Class<? super P>[])contracts);
            return this;
        }

        @Override
        public ResourceConfig setApplication(Application application) {
            ResourceConfig.this.invalidateCache();
            return ResourceConfig.this._setApplication(application);
        }
    }

    private class Immutable
    extends DefaultConfig
    implements InternalState {
        private Immutable(DefaultConfig configurable) {
            super(configurable);
        }

        @Override
        public ResourceConfig addClasses(Set<Class<?>> classes) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addResources(Set<Resource> resources) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addFinder(ResourceFinder resourceFinder) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addBinders(Set<Binder> binders) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addProperties(Map<String, Object> properties) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addSingletons(Set<Object> singletons) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig setClassLoader(ClassLoader classLoader) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public Immutable setProperty(String name, Object value) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public Immutable setProperties(Map<String, ?> properties) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public Immutable register(Class<?> providerClass) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public Immutable register(Class<?> providerClass, int bindingPriority) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public <T> Immutable register(Class<T> providerClass, Class<? super T> ... contracts) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public <T> Immutable register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public Immutable register(Object provider) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public Immutable register(Object provider, int bindingPriority) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public <T> Immutable register(Object provider, Class<? super T> ... contracts) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public <T> Immutable register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig setApplication(Application application) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }
    }

    private static interface InternalState
    extends Configurable {
        public ResourceConfig addClasses(Set<Class<?>> var1);

        public ResourceConfig addResources(Set<Resource> var1);

        public ResourceConfig addFinder(ResourceFinder var1);

        public ResourceConfig addBinders(Set<Binder> var1);

        public ResourceConfig addProperties(Map<String, Object> var1);

        public ResourceConfig addSingletons(Set<Object> var1);

        public ResourceConfig setClassLoader(ClassLoader var1);

        public ResourceConfig setApplication(Application var1);

        @Override
        public InternalState setProperty(String var1, Object var2);

        @Override
        public InternalState setProperties(Map<String, ?> var1);

        @Override
        public InternalState register(Class<?> var1);

        @Override
        public InternalState register(Class<?> var1, int var2);

        @Override
        public <T> InternalState register(Class<T> var1, Class<? super T> ... var2);

        @Override
        public <T> InternalState register(Class<T> var1, int var2, Class<? super T> ... var3);

        @Override
        public InternalState register(Object var1);

        @Override
        public InternalState register(Object var1, int var2);

        @Override
        public <T> InternalState register(Object var1, Class<? super T> ... var2);

        @Override
        public <T> InternalState register(Object var1, int var2, Class<? super T> ... var3);
    }
}

