/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.config;

import java.util.Collections;
import java.util.List;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.wadl.config.WadlGeneratorConfig;

public class WadlGeneratorConfigLoader {
    public static WadlGeneratorConfig loadWadlGeneratorsFromConfig(ResourceConfig resourceConfig) {
        Object wadlGeneratorConfigProperty = resourceConfig.getProperty("jersey.config.server.wadl.generatorConfig");
        if (wadlGeneratorConfigProperty == null) {
            return new WadlGeneratorConfig(){

                @Override
                public List configure() {
                    return Collections.EMPTY_LIST;
                }
            };
        }
        try {
            Class<WadlGeneratorConfig> configClazz;
            if (wadlGeneratorConfigProperty instanceof WadlGeneratorConfig) {
                return (WadlGeneratorConfig)wadlGeneratorConfigProperty;
            }
            if (wadlGeneratorConfigProperty instanceof Class) {
                configClazz = ((Class)wadlGeneratorConfigProperty).asSubclass(WadlGeneratorConfig.class);
            } else if (wadlGeneratorConfigProperty instanceof String) {
                configClazz = ReflectionHelper.classForNameWithException((String)wadlGeneratorConfigProperty).asSubclass(WadlGeneratorConfig.class);
            } else {
                throw new RuntimeException("The property jersey.config.server.wadl.generatorConfig is an invalid type: " + wadlGeneratorConfigProperty.getClass().getName() + " (supported: String, Class<? extends WadlGeneratorConfiguration>," + " WadlGeneratorConfiguration)");
            }
            return configClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load WadlGeneratorConfiguration, check the configuration of jersey.config.server.wadl.generatorConfig", e);
        }
    }
}

