/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.client.ClientBinder;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.client.HttpUrlConnector;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.model.internal.DefaultConfig;

public class ClientConfig
implements Configuration,
Configurable {
    private State state;

    public ClientConfig() {
        this.state = new State(null);
    }

    public ClientConfig(Class<?> ... providerClasses) {
        this();
        for (Class<?> providerClass : providerClasses) {
            this.state.register((Class)providerClass);
        }
    }

    public ClientConfig(Object ... providers) {
        this();
        for (Object provider : providers) {
            this.state.register(provider);
        }
    }

    ClientConfig(JerseyClient parent) {
        this.state = new State(parent);
        this.state.setConnector(new HttpUrlConnector());
    }

    ClientConfig(JerseyClient parent, Configurable that) {
        if (that instanceof ClientConfig) {
            this.state = ((ClientConfig)that).state.copy(parent);
            if (this.state.getConnector() == null) {
                this.state.setConnector(new HttpUrlConnector());
            }
        } else {
            this.state = new State(parent);
            this.state.setConnector(new HttpUrlConnector());
            this.state = this.state.setProperties((Map)that.getProperties());
            for (Object object : that.getProviderInstances()) {
                this.state = this.state.register(object);
            }
            for (Class clazz : that.getProviderClasses()) {
                this.state = this.state.register(clazz);
            }
            for (Feature feature : that.getFeatures()) {
                this.state = this.state.register((Object)feature, new Class[]{Feature.class});
            }
        }
    }

    private ClientConfig(State state) {
        this.state = state;
    }

    ClientConfig snapshot() {
        this.state.markAsShared();
        return new ClientConfig(this.state);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    @Override
    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.state.runtimeClientConfig != null ? this.state.runtimeClientConfig.getFeatures() : this.state.getFeatures();
    }

    @Override
    public Set<Class<?>> getProviderClasses() {
        return this.state.getProviderClasses();
    }

    @Override
    public Set<Object> getProviderInstances() {
        return this.state.getProviderInstances();
    }

    @Override
    public ClientConfig updateFrom(Configurable configuration) {
        this.state = this.state.updateFrom(configuration);
        return this;
    }

    @Override
    public ClientConfig register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    @Override
    public ClientConfig register(Object provider) {
        this.state = this.state.register(provider);
        return this;
    }

    @Override
    public ClientConfig register(Class<?> providerClass, int bindingPriority) {
        this.state = this.state.register((Class)providerClass, bindingPriority);
        return this;
    }

    @Override
    public <T> ClientConfig register(Class<T> providerClass, Class<? super T> ... contracts) {
        this.state = this.state.register((Class)providerClass, (Class[])contracts);
        return this;
    }

    @Override
    public <T> ClientConfig register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
        this.state = this.state.register((Class)providerClass, bindingPriority, (Class[])contracts);
        return this;
    }

    @Override
    public ClientConfig register(Object provider, int bindingPriority) {
        this.state = this.state.register(provider, bindingPriority);
        return this;
    }

    @Override
    public <T> ClientConfig register(Object provider, Class<? super T> ... contracts) {
        this.state = this.state.register(provider, (Class[])contracts);
        return this;
    }

    @Override
    public <T> ClientConfig register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
        this.state = this.state.register(provider, bindingPriority, (Class[])contracts);
        return this;
    }

    @Override
    public ClientConfig setProperties(Map<String, ?> properties) {
        this.state = this.state.setProperties((Map)properties);
        return this;
    }

    @Override
    public ClientConfig setProperty(String name, Object value) {
        this.state = this.state.setProperty(name, value);
        return this;
    }

    public ClientConfig connector(Connector connector) {
        this.state = this.state.setConnector(connector);
        return this;
    }

    public ClientConfig binders(Binder ... binders) {
        this.state = this.state.binders(binders);
        return this;
    }

    public Connector getConnector() {
        return this.state.getConnector();
    }

    ClientRuntime getRuntime() {
        return (ClientRuntime)this.state.runtime.get();
    }

    Configuration getRuntimeConfig() {
        return this.state.runtimeClientConfig;
    }

    public JerseyClient getClient() {
        return this.state.getClient();
    }

    void checkClient() throws IllegalStateException {
        if (this.getClient() == null) {
            throw new IllegalStateException("Client configuration does not contain a parent client instance.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements Configuration,
    Configurable {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private volatile StateChangeStrategy strategy;
        private final DefaultConfig config;
        private final List<Binder> binders;
        private final JerseyClient client;
        private Connector connector;
        private RuntimeClientConfig runtimeClientConfig;
        private final Value<ClientRuntime> runtime = Values.lazy(new Value<ClientRuntime>(){

            @Override
            public ClientRuntime get() {
                return State.this.initRuntime();
            }
        });

        State(JerseyClient client) {
            this.client = client;
            this.strategy = IDENTITY;
            this.config = new DefaultConfig();
            this.binders = Lists.newLinkedList();
            this.connector = null;
        }

        private State(JerseyClient client, State original) {
            this.client = client;
            this.strategy = IDENTITY;
            this.config = new DefaultConfig(original.config);
            this.binders = Lists.newLinkedList(original.binders);
            this.connector = original.connector;
        }

        State copy() {
            return new State(this.client, this);
        }

        State copy(JerseyClient client) {
            return new State(client, this);
        }

        void markAsShared() {
            this.strategy = COPY_ON_CHANGE;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.config.getProperties();
        }

        @Override
        public Object getProperty(String name) {
            return this.config.getProperty(name);
        }

        @Override
        public Collection<Feature> getFeatures() {
            return this.config.getFeatures();
        }

        @Override
        public Set<Class<?>> getProviderClasses() {
            return this.config.getProviderClasses();
        }

        @Override
        public Set<Object> getProviderInstances() {
            return this.config.getProviderInstances();
        }

        @Override
        public State updateFrom(Configurable configuration) {
            return ((ClientConfig)configuration).state.copy(this.client);
        }

        @Override
        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.config.register(providerClass);
            return state;
        }

        @Override
        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.config.register(provider);
            return state;
        }

        @Override
        public State register(Class<?> providerClass, int bindingPriority) {
            State state = this.strategy.onChange(this);
            state.config.register(providerClass, bindingPriority);
            return state;
        }

        @Override
        public <T> State register(Class<T> providerClass, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            state.config.register(providerClass, (Class<? super P>[])contracts);
            return state;
        }

        @Override
        public <T> State register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            state.config.register(providerClass, bindingPriority, (Class<? super P>[])contracts);
            return state;
        }

        @Override
        public State register(Object provider, int bindingPriority) {
            State state = this.strategy.onChange(this);
            state.config.register(provider, bindingPriority);
            return state;
        }

        @Override
        public <T> State register(Object provider, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            state.config.register(provider, (Class<? super P>[])contracts);
            return state;
        }

        @Override
        public <T> State register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            state.config.register(provider, bindingPriority, (Class<? super P>[])contracts);
            return state;
        }

        @Override
        public State setProperties(Map<String, ?> properties) {
            State state = this.strategy.onChange(this);
            state.config.setProperties(properties);
            return state;
        }

        @Override
        public State setProperty(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.config.setProperty(name, value);
            return state;
        }

        public State binders(Binder ... binders) {
            if (binders != null && binders.length > 0) {
                State state = this.strategy.onChange(this);
                Collections.addAll(state.binders, binders);
                return state;
            }
            return this;
        }

        public State setConnector(Connector connector) {
            State state = this.strategy.onChange(this);
            state.connector = connector;
            return state;
        }

        Connector getConnector() {
            return this.connector;
        }

        JerseyClient getClient() {
            return this.client;
        }

        private ClientRuntime initRuntime() {
            ServiceLocator locator;
            this.markAsShared();
            this.runtimeClientConfig = new RuntimeClientConfig(this.config);
            AbstractBinder configBinder = new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bind(State.this.runtimeClientConfig).to(Configuration.class).to(Configurable.class);
                }
            };
            if (this.binders.isEmpty()) {
                locator = Injections.createLocator(configBinder, new ClientBinder());
            } else {
                ArrayList<Binder> allBinders = new ArrayList<Binder>(this.binders.size() + 2);
                allBinders.add(configBinder);
                allBinders.add(new ClientBinder());
                allBinders.addAll(this.binders);
                locator = Injections.createLocator(allBinders.toArray(new Binder[allBinders.size()]));
            }
            ProviderBinder.configureFeatures(this.runtimeClientConfig.getFeatureBag(), this.runtimeClientConfig, locator);
            ProviderBinder.bindProviders(this.runtimeClientConfig.getProviderBag(), ConstrainedTo.Type.CLIENT, null, locator);
            this.runtimeClientConfig.lock();
            final ClientRuntime runtime = new ClientRuntime(this.connector, locator);
            this.client.addListener(new JerseyClient.LifecycleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClose() {
                    try {
                        runtime.close();
                    }
                    finally {
                        ServiceLocatorFactory.getInstance().destroy(locator.getName());
                    }
                }
            });
            return runtime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof State)) {
                return false;
            }
            State other = (State)obj;
            return this == other && super.equals(other) && (this.binders == other.binders || ((Object)this.binders).equals(other.binders)) && (this.connector == other.connector || this.connector != null && this.connector.equals(other.connector));
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + super.hashCode();
            hash = 41 * hash + ((Object)this.binders).hashCode();
            hash = 41 * hash + (this.connector != null ? this.connector.hashCode() : 0);
            return hash;
        }

        private static class RuntimeClientConfig
        extends DefaultConfig
        implements Configuration {
            public RuntimeClientConfig(DefaultConfig config) {
                super(config);
            }

            @Override
            public RuntimeClientConfig register(Class<?> providerClass) {
                super.register(providerClass);
                return this;
            }

            @Override
            public RuntimeClientConfig setProperties(Map<String, ?> properties) {
                super.setProperties(properties);
                return this;
            }

            @Override
            public RuntimeClientConfig setProperty(String name, Object value) {
                super.setProperty(name, value);
                return this;
            }

            @Override
            public RuntimeClientConfig register(Object provider) {
                super.register(provider);
                return this;
            }

            @Override
            public RuntimeClientConfig register(Class<?> providerClass, int bindingPriority) {
                super.register(providerClass, bindingPriority);
                return this;
            }

            @Override
            public <P> RuntimeClientConfig register(Class<P> providerClass, Class<? super P> ... contracts) {
                super.register(providerClass, contracts);
                return this;
            }

            @Override
            public <P> RuntimeClientConfig register(Class<P> providerClass, int bindingPriority, Class<? super P> ... contracts) {
                super.register(providerClass, bindingPriority, contracts);
                return this;
            }

            @Override
            public RuntimeClientConfig register(Object provider, int bindingPriority) {
                super.register(provider, bindingPriority);
                return this;
            }

            @Override
            public <P> RuntimeClientConfig register(Object provider, Class<? super P> ... contracts) {
                super.register(provider, contracts);
                return this;
            }

            @Override
            public <P> RuntimeClientConfig register(Object provider, int bindingPriority, Class<? super P> ... contracts) {
                super.register(provider, bindingPriority, contracts);
                return this;
            }

            @Override
            public Configuration updateFrom(Configurable configuration) {
                throw new UnsupportedOperationException();
            }
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

