/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.spi.Errors;

public abstract class ResourceModelValidator
implements ResourceModelVisitor {
    private final List<ResourceModelIssue> issueList = Lists.newLinkedList();

    public List<ResourceModelIssue> getIssueList() {
        return this.issueList;
    }

    public boolean fatalIssuesFound() {
        for (ResourceModelIssue issue : this.getIssueList()) {
            if (!issue.isFatal()) continue;
            return true;
        }
        return false;
    }

    public void cleanIssueList() {
        this.issueList.clear();
    }

    public void validate(final ResourceModelComponent component) {
        Errors.process(new Errors.Closure<Void>(){

            @Override
            public Void invoke() {
                Errors.mark();
                ResourceModelValidator.this.validateWithErrors(component);
                ResourceModelValidator.this.issueList.addAll(ModelErrors.getErrorsAsResourceModelIssues(true));
                Errors.unmark();
                return null;
            }
        });
    }

    private void validateWithErrors(ResourceModelComponent component) {
        component.accept(this);
        List<? extends ResourceModelComponent> componentList = component.getComponents();
        if (null != componentList) {
            for (ResourceModelComponent resourceModelComponent : componentList) {
                this.validateWithErrors(resourceModelComponent);
            }
        }
    }
}

