/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Singleton;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public class LinkProvider
implements HeaderDelegateProvider<Link> {
    @Override
    public boolean supports(Class<?> type) {
        return Link.class.isAssignableFrom(type);
    }

    @Override
    public Link fromString(String value) throws IllegalArgumentException {
        Link.Builder lb;
        Utils.throwIllegalArgumentExceptionIfNull(value, LocalizationMessages.LINK_IS_NULL());
        StringTokenizer st = new StringTokenizer(value.trim(), "<>;=\"", true);
        try {
            this.checkToken(st, "<");
            lb = Link.fromUri(st.nextToken().trim());
            this.checkToken(st, ">");
            while (st.hasMoreTokens()) {
                this.checkToken(st, ";");
                String n = st.nextToken().trim();
                this.checkToken(st, "=");
                this.checkToken(st, "\"");
                String v = st.nextToken();
                this.checkToken(st, "\"");
                lb.param(n, v);
            }
        }
        catch (Throwable e) {
            lb = null;
        }
        if (lb == null) {
            throw new IllegalArgumentException("Unable to parse link " + value);
        }
        return lb.build();
    }

    private void checkToken(StringTokenizer st, String expected) throws AssertionError {
        String token;
        while ((token = st.nextToken().trim()).length() == 0) {
        }
        if (!token.equals(expected)) {
            throw new AssertionError((Object)("Expected token " + expected + " but found " + token));
        }
    }

    @Override
    public String toString(Link value) {
        Utils.throwIllegalArgumentExceptionIfNull(value, LocalizationMessages.LINK_IS_NULL());
        Map<String, String> map = value.getParams();
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(value.getUri()).append('>');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("; ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        return sb.toString();
    }

    static List<String> getLinkRelations(String rel) {
        return rel == null ? null : Arrays.asList(Tokenizer.tokenize(rel, "\" "));
    }
}

