/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.ExceptionWrapperInterceptor;
import org.glassfish.jersey.message.internal.InterceptorExecutor;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;

public final class WriterInterceptorExecutor
extends InterceptorExecutor
implements WriterInterceptorContext {
    public static final String INTERCEPTORS = "jersey.runtime.writer.interceptors";
    private OutputStream outputStream;
    private final MultivaluedMap<String, Object> headers;
    private Object entity;
    private final Iterator<WriterInterceptor> iterator;

    public WriterInterceptorExecutor(Object entity, Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, PropertiesDelegate propertiesDelegate, OutputStream entityStream, MessageBodyWorkers workers, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean intercept, boolean writeEntity) {
        super(rawType, type, annotations, mediaType, propertiesDelegate);
        this.entity = entity;
        this.headers = headers;
        this.outputStream = entityStream;
        ArrayList<WriterInterceptor> effectiveInterceptors = new ArrayList<WriterInterceptor>();
        Object writerInterceptorsProperty = propertiesDelegate.getProperty(INTERCEPTORS);
        List<WriterInterceptor> writerInterceptors = writerInterceptorsProperty instanceof Collection ? (List<WriterInterceptor>)writerInterceptorsProperty : workers.getWriterInterceptors();
        for (WriterInterceptor interceptor : writerInterceptors) {
            if (!intercept && !(interceptor instanceof ExceptionWrapperInterceptor)) continue;
            effectiveInterceptors.add(interceptor);
        }
        effectiveInterceptors.add(new TerminalWriterInterceptor(workers, sizeCallback, writeEntity));
        this.iterator = effectiveInterceptors.iterator();
    }

    public WriterInterceptor getNextInterceptor() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }

    @Override
    public void proceed() throws IOException {
        WriterInterceptor nextInterceptor = this.getNextInterceptor();
        if (nextInterceptor == null) {
            throw new ProcessingException(LocalizationMessages.ERROR_INTERCEPTOR_WRITER_PROCEED());
        }
        nextInterceptor.aroundWriteTo(this);
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    private static class TerminalWriterInterceptor
    implements WriterInterceptor {
        private final MessageBodyWorkers workers;
        private final MessageBodyWorkers.MessageBodySizeCallback sizeCallback;
        private final boolean writeEntity;

        public TerminalWriterInterceptor(MessageBodyWorkers workers, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean writeEntity) {
            this.workers = workers;
            this.sizeCallback = sizeCallback;
            this.writeEntity = writeEntity;
        }

        @Override
        public void aroundWriteTo(WriterInterceptorContext context) throws WebApplicationException, IOException {
            MessageBodyWriter<?> writer = this.workers.getMessageBodyWriter(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType());
            if (writer == null) {
                throw new MessageBodyProviderNotFoundException(LocalizationMessages.ERROR_NOTFOUND_MESSAGEBODYWRITER(context.getMediaType(), context.getType(), context.getGenericType()));
            }
            if (this.sizeCallback != null) {
                this.sizeCallback.onRequestEntitySize(-1L);
            }
            if (this.writeEntity) {
                writer.writeTo(context.getEntity(), context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType(), context.getHeaders(), context.getOutputStream());
            }
        }
    }
}

