/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Uri;
import javax.ws.rs.client.ClientFactory;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.uri.ExtendedUriInfo;

final class WebTargetValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Context
    private Configuration config;

    @Inject
    public WebTargetValueFactoryProvider(ServiceLocator locator) {
        super(null, locator, Parameter.Source.URI);
    }

    protected AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        Class<?> rawParameterType = parameter.getRawType();
        if (rawParameterType == WebTarget.class) {
            Object o = this.config.getProperty("jersey.config.server.webTargetConfiguration");
            ClientConfig clientConfig = null;
            if (o != null && o instanceof Map) {
                Map clientConfigMap = (Map)o;
                clientConfig = (ClientConfig)clientConfigMap.get(parameterName);
            }
            return new WebTargetValueFactory(parameterName, clientConfig);
        }
        return null;
    }

    private static final class WebTargetValueFactory
    extends AbstractHttpContextValueFactory<WebTarget> {
        private final String uriValue;
        private final ClientConfig clientConfig;

        WebTargetValueFactory(String uriValue, ClientConfig clientConfig) {
            this.uriValue = uriValue;
            this.clientConfig = clientConfig;
        }

        @Override
        protected WebTarget get(HttpContext context) {
            ExtendedUriInfo uriInfo = context.getUriInfo();
            URI uri = UriBuilder.fromUri(this.uriValue).buildFromEncodedMap(Maps.transformValues(uriInfo.getPathParameters(), (Function)new Function<List<String>, Object>(){

                public Object apply(List<String> input) {
                    return input.isEmpty() ? null : input.get(0);
                }
            }));
            if (!uri.isAbsolute()) {
                uri = UriBuilder.fromUri(uriInfo.getBaseUri()).path(uri.toString()).build(new Object[0]);
            }
            if (this.clientConfig == null) {
                return ClientFactory.newClient().target(uri);
            }
            return ClientFactory.newClient(this.clientConfig).target(uri);
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<Uri> {
        public InjectionResolver() {
            super(WebTargetValueFactoryProvider.class);
        }
    }
}

