/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.MethodSelectingRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedUriRouter;
import org.glassfish.jersey.server.internal.routing.PushMethodHandlerRouter;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RouterBinder;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.internal.routing.SubResourceLocatorRouter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.uri.PathPattern;

public final class RuntimeModelBuilder {
    private final RouterBinder.RootRouteBuilder<PathPattern> rootBuilder;
    private final ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    private final ServiceLocator locator;
    private final PushMethodHandlerRouter.Builder pushHandlerAcceptorBuilder;
    private final MethodSelectingRouter.Builder methodSelectingAcceptorBuilder;
    private final MessageBodyWorkers workers;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters;
    private Iterable<RankedProvider<ReaderInterceptor>> globalReaderInterceptors;
    private Iterable<RankedProvider<WriterInterceptor>> globalWriterInterceptors;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors;
    private Iterable<DynamicFeature> dynamicFeatures;
    private TreeMap<PathPattern, List<MethodAcceptorPair>> rootAcceptors = Maps.newTreeMap(PathPattern.COMPARATOR);
    private TreeMap<PathPattern, TreeMap<PathPattern, List<MethodAcceptorPair>>> subResourceAcceptors = Maps.newTreeMap(PathPattern.COMPARATOR);

    @Inject
    public RuntimeModelBuilder(RouterBinder.RootRouteBuilder<PathPattern> rootBuilder, ResourceMethodInvoker.Builder resourceMethodInvokerBuilder, ServiceLocator locator, PushMethodHandlerRouter.Builder pushHandlerAcceptorBuilder, MethodSelectingRouter.Builder methodSelectingAcceptorBuilder, MessageBodyWorkers workers) {
        this.rootBuilder = rootBuilder;
        this.resourceMethodInvokerBuilder = resourceMethodInvokerBuilder;
        this.locator = locator;
        this.pushHandlerAcceptorBuilder = pushHandlerAcceptorBuilder;
        this.methodSelectingAcceptorBuilder = methodSelectingAcceptorBuilder;
        this.workers = workers;
    }

    private RuntimeModelBuilder(RuntimeModelBuilder original) {
        this.rootBuilder = original.rootBuilder;
        this.resourceMethodInvokerBuilder = original.resourceMethodInvokerBuilder;
        this.locator = original.locator;
        this.pushHandlerAcceptorBuilder = original.pushHandlerAcceptorBuilder;
        this.methodSelectingAcceptorBuilder = original.methodSelectingAcceptorBuilder;
        this.workers = original.workers;
        this.nameBoundRequestFilters = original.nameBoundRequestFilters;
        this.nameBoundResponseFilters = original.nameBoundResponseFilters;
        this.globalReaderInterceptors = original.globalReaderInterceptors;
        this.globalWriterInterceptors = original.globalWriterInterceptors;
        this.nameBoundReaderInterceptors = original.nameBoundReaderInterceptors;
        this.nameBoundWriterInterceptors = original.nameBoundWriterInterceptors;
        this.dynamicFeatures = original.dynamicFeatures;
    }

    public RuntimeModelBuilder copy() {
        return new RuntimeModelBuilder(this);
    }

    public void process(final Resource resource, final boolean subResourceMode) {
        ResourceMethod resourceLocator;
        if (!resource.isRootResource() && !subResourceMode) {
            return;
        }
        if (!resource.getResourceMethods().isEmpty()) {
            PathPattern closedResourcePathPattern = subResourceMode ? PathPattern.END_OF_PATH_PATTERN : PathPattern.asClosed(resource.getPathPattern());
            List<MethodAcceptorPair> sameResourcePathList = this.getAcceptorList(this.rootAcceptors, closedResourcePathPattern);
            sameResourcePathList.addAll(Lists.transform(resource.getResourceMethods(), (Function)new Function<ResourceMethod, MethodAcceptorPair>(){

                public MethodAcceptorPair apply(ResourceMethod methodModel) {
                    return new MethodAcceptorPair(methodModel, resource, RuntimeModelBuilder.this.createSingleMethodAcceptor(methodModel, subResourceMode));
                }
            }));
        }
        if ((resourceLocator = resource.getResourceLocator()) != null) {
            TreeMap<PathPattern, List<MethodAcceptorPair>> sameResourcePathMap = this.getPatternAcceptorListMap(resource.getPathPattern());
            List<MethodAcceptorPair> locatorList = this.getAcceptorList(sameResourcePathMap, PathPattern.OPEN_ROOT_PATH_PATTERN);
            locatorList.add(new MethodAcceptorPair(resourceLocator, resource, this.createSingleMethodAcceptor(resourceLocator, subResourceMode)));
        }
        if (resource.getChildResources().size() > 0) {
            PathPattern resourcePath = subResourceMode ? PathPattern.OPEN_ROOT_PATH_PATTERN : resource.getPathPattern();
            TreeMap<PathPattern, List<MethodAcceptorPair>> sameResourcePathMap = this.getPatternAcceptorListMap(resourcePath);
            for (Resource child : resource.getChildResources()) {
                PathPattern childRelativePath = new PathPattern(child.getPath());
                List<MethodAcceptorPair> samePathMethodAcceptorPairs = this.getAcceptorList(sameResourcePathMap, childRelativePath);
                for (ResourceMethod resourceMethod : child.getAllMethods()) {
                    samePathMethodAcceptorPairs.add(new MethodAcceptorPair(resourceMethod, resource, this.createSingleMethodAcceptor(resourceMethod, subResourceMode)));
                }
            }
        }
    }

    private TreeMap<PathPattern, List<MethodAcceptorPair>> getPatternAcceptorListMap(PathPattern pathPattern) {
        TreeMap sameResourcePathMap = this.subResourceAcceptors.get(pathPattern);
        if (sameResourcePathMap == null) {
            sameResourcePathMap = Maps.newTreeMap(PathPattern.COMPARATOR);
            this.subResourceAcceptors.put(pathPattern, sameResourcePathMap);
        }
        return sameResourcePathMap;
    }

    private List<MethodAcceptorPair> getAcceptorList(TreeMap<PathPattern, List<MethodAcceptorPair>> sameResourcePathMap, PathPattern childRelativePath) {
        LinkedList samePathMethodAcceptorPairs = sameResourcePathMap.get(childRelativePath);
        if (samePathMethodAcceptorPairs == null) {
            samePathMethodAcceptorPairs = Lists.newLinkedList();
            sameResourcePathMap.put(childRelativePath, samePathMethodAcceptorPairs);
        }
        return samePathMethodAcceptorPairs;
    }

    private Router createSingleMethodAcceptor(ResourceMethod resourceMethod, boolean subResourceMode) {
        Router methodAcceptor = null;
        switch (resourceMethod.getType()) {
            case RESOURCE_METHOD: 
            case SUB_RESOURCE_METHOD: {
                methodAcceptor = Routers.asTreeAcceptor(this.createInflector(resourceMethod));
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                methodAcceptor = new SubResourceLocatorRouter(this.locator, this, resourceMethod);
            }
        }
        if (subResourceMode) {
            return methodAcceptor;
        }
        return this.pushHandlerAcceptorBuilder.build(resourceMethod.getInvocable().getHandler(), methodAcceptor);
    }

    private Inflector<ContainerRequest, ContainerResponse> createInflector(ResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method, this.nameBoundRequestFilters, this.nameBoundResponseFilters, this.globalReaderInterceptors, this.globalWriterInterceptors, this.nameBoundReaderInterceptors, this.nameBoundWriterInterceptors, this.dynamicFeatures);
    }

    private Router createRootTreeAcceptor(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder, boolean subResourceMode) {
        Router routingRoot = lastRoutedBuilder != null ? lastRoutedBuilder.build() : Routers.acceptingTree(new Function<ContainerRequest, ContainerRequest>(){

            public ContainerRequest apply(ContainerRequest input) {
                return input;
            }
        }).build();
        if (subResourceMode) {
            return routingRoot;
        }
        return this.rootBuilder.root(routingRoot);
    }

    private RouterBinder.RouteToPathBuilder<PathPattern> routeMethodAcceptor(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder, PathPattern pathPattern, Router uriPushingAcceptor, Router methodAcceptor, boolean subResourceMode) {
        if (subResourceMode) {
            return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(methodAcceptor);
        }
        return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(uriPushingAcceptor).to(methodAcceptor);
    }

    public Router buildModel(boolean subResourceMode) {
        PushMatchedUriRouter uriPushingRouter = (PushMatchedUriRouter)this.locator.createAndInitialize(PushMatchedUriRouter.class);
        RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder = null;
        if (!this.rootAcceptors.isEmpty()) {
            for (Map.Entry<PathPattern, List<MethodAcceptorPair>> entry : this.rootAcceptors.entrySet()) {
                PathPattern closedResourcePathPattern = entry.getKey();
                List<MethodAcceptorPair> methodAcceptorPairs = entry.getValue();
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, closedResourcePathPattern, uriPushingRouter, this.methodSelectingAcceptorBuilder.build(this.workers, methodAcceptorPairs), subResourceMode);
            }
            this.rootAcceptors.clear();
        }
        if (!this.subResourceAcceptors.isEmpty()) {
            for (Map.Entry<PathPattern, Object> entry : this.subResourceAcceptors.entrySet()) {
                RouterBinder.RouteToPathBuilder srRoutedBuilder = null;
                for (Map.Entry singlePathEntry : ((TreeMap)entry.getValue()).entrySet()) {
                    LinkedList resourceMethods = Lists.newLinkedList();
                    MethodAcceptorPair resourceLocator = null;
                    for (MethodAcceptorPair methodAcceptorPair : (List)singlePathEntry.getValue()) {
                        if (methodAcceptorPair.model.getType() == ResourceMethod.JaxrsType.RESOURCE_METHOD) {
                            resourceMethods.add(methodAcceptorPair);
                            continue;
                        }
                        resourceLocator = methodAcceptorPair;
                    }
                    if (!resourceMethods.isEmpty()) {
                        PathPattern subResourceMethodPath = PathPattern.asClosed((PathPattern)singlePathEntry.getKey());
                        srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(subResourceMethodPath).to(uriPushingRouter).to(this.methodSelectingAcceptorBuilder.build(this.workers, resourceMethods));
                    }
                    if (resourceLocator == null) continue;
                    srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route((PathPattern)singlePathEntry.getKey()).to(uriPushingRouter).to(resourceLocator.router);
                }
                assert (srRoutedBuilder != null);
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, entry.getKey(), uriPushingRouter, srRoutedBuilder.build(), subResourceMode);
            }
            this.subResourceAcceptors.clear();
        }
        return this.createRootTreeAcceptor(lastRoutedBuilder, subResourceMode);
    }

    private RouterBinder.RouteBuilder<PathPattern> routedBuilder(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        return lastRoutedBuilder == null ? this.rootBuilder : lastRoutedBuilder;
    }

    public void setGlobalInterceptors(Iterable<RankedProvider<ReaderInterceptor>> readerInterceptors, Iterable<RankedProvider<WriterInterceptor>> writerInterceptors) {
        this.globalReaderInterceptors = readerInterceptors;
        this.globalWriterInterceptors = writerInterceptors;
    }

    public void setBoundProviders(MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors, Iterable<DynamicFeature> dynamicFeatures) {
        this.nameBoundRequestFilters = nameBoundRequestFilters;
        this.nameBoundResponseFilters = nameBoundResponseFilters;
        this.nameBoundReaderInterceptors = nameBoundReaderInterceptors;
        this.nameBoundWriterInterceptors = nameBoundWriterInterceptors;
        this.dynamicFeatures = dynamicFeatures;
    }
}

