/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

abstract class AbstractJavaResourceMethodDispatcher
implements ResourceMethodDispatcher {
    @Inject
    private Provider<ConfiguredValidator> validatorProvider;
    private final Method method;
    private final InvocationHandler methodHandler;

    AbstractJavaResourceMethodDispatcher(Invocable resourceMethod, InvocationHandler methodHandler) {
        this.method = resourceMethod.getHandlingMethod();
        this.methodHandler = methodHandler;
    }

    @Override
    public final Response dispatch(Object resource, Request request) throws ProcessingException {
        return this.doDispatch(resource, request);
    }

    protected abstract Response doDispatch(Object var1, Request var2) throws ProcessingException;

    final Object invoke(Object resource, Object ... args) throws ProcessingException {
        try {
            ConfiguredValidator validator = (ConfiguredValidator)this.validatorProvider.get();
            this.validateInput(validator, resource, args);
            Object invocationResult = this.methodHandler.invoke(resource, this.method, args);
            this.validateResult(validator, resource, invocationResult);
            return invocationResult;
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException(ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }

    private void validateInput(Validator validator, Object resource, Object[] args) throws ConstraintViolationException {
        if (validator != null) {
            HashSet constraintViolations = Sets.newHashSet();
            constraintViolations.addAll(validator.validate(resource, new Class[0]));
            constraintViolations.addAll(validator.forExecutables().validateParameters(resource, this.method, args, new Class[0]));
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException((Set)constraintViolations);
            }
        }
    }

    private void validateResult(Validator validator, Object resource, Object invocationResult) {
        if (validator != null) {
            HashSet constraintViolations = Sets.newHashSet();
            constraintViolations.addAll(validator.forExecutables().validateReturnValue(resource, this.method, invocationResult, new Class[0]));
            if (invocationResult instanceof Response) {
                constraintViolations.addAll(validator.forExecutables().validateReturnValue(resource, this.method, ((Response)invocationResult).getEntity(), new Class[0]));
            }
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException((Set)constraintViolations);
            }
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

