/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.client.ClientException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ExtendedConfig;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientAsyncExecutorsFactory;
import org.glassfish.jersey.client.ClientFilteringStages;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.client.ResponseCallback;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

class ClientRuntime {
    private final Stage<ClientRequest> requestProcessingRoot;
    private final Stage<ClientResponse> responseProcessingRoot;
    private final Connector connector;
    private final ExtendedConfig config;
    private final RequestScope requestScope;
    private final ClientAsyncExecutorsFactory asyncExecutorsFactory;
    private final ServiceLocator locator;

    public ClientRuntime(ExtendedConfig config, Connector connector, ServiceLocator locator) {
        Stage.Builder<ClientRequest> requestingChainBuilder = Stages.chain((Function)locator.createAndInitialize(RequestProcessingInitializationStage.class));
        ChainableStage<ClientRequest> requestFilteringStage = ClientFilteringStages.createRequestFilteringStage(locator);
        this.requestProcessingRoot = requestFilteringStage != null ? requestingChainBuilder.build(requestFilteringStage) : requestingChainBuilder.build();
        ChainableStage<ClientResponse> responseFilteringStage = ClientFilteringStages.createResponseFilteringStage(locator);
        this.responseProcessingRoot = responseFilteringStage != null ? responseFilteringStage : Stages.identity();
        this.config = config;
        this.connector = connector;
        this.requestScope = (RequestScope)locator.getService(RequestScope.class, new Annotation[0]);
        this.asyncExecutorsFactory = new ClientAsyncExecutorsFactory(locator);
        this.locator = locator;
    }

    public void submit(final ClientRequest request, final ResponseCallback callback) {
        this.submit(this.asyncExecutorsFactory.getRequestingExecutor(request), new Runnable(){

            @Override
            public void run() {
                final RequestScope.Instance currentScopeInstance = ClientRuntime.this.requestScope.referenceCurrent();
                AsyncConnectorCallback connectorCallback = new AsyncConnectorCallback(){

                    @Override
                    public void response(final ClientResponse response) {
                        ClientRuntime.this.submit(ClientRuntime.this.asyncExecutorsFactory.getRespondingExecutor(request), currentScopeInstance, new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ClientResponse processedResponse;
                                try {
                                    processedResponse = Stages.process(response, ClientRuntime.this.responseProcessingRoot);
                                }
                                catch (Throwable throwable) {
                                    this.failure(throwable);
                                    return;
                                }
                                try {
                                    callback.completed(processedResponse, ClientRuntime.this.requestScope);
                                }
                                finally {
                                    currentScopeInstance.release();
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failure(Throwable failure) {
                        try {
                            callback.failed(failure instanceof ClientException ? (ClientException)failure : new ClientException(failure));
                        }
                        finally {
                            currentScopeInstance.release();
                        }
                    }
                };
                try {
                    ClientRuntime.this.connector.apply(ClientRuntime.this.addUserAgent(Stages.process(request, ClientRuntime.this.requestProcessingRoot), ClientRuntime.this.connector.getName()), connectorCallback);
                }
                catch (AbortException aborted) {
                    connectorCallback.response(aborted.getAbortResponse());
                }
                catch (Throwable throwable) {
                    connectorCallback.failure(throwable);
                }
            }
        });
    }

    private Future<?> submit(ExecutorService executor, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                ClientRuntime.this.requestScope.runInScope(task);
            }
        });
    }

    private Future<?> submit(ExecutorService executor, final RequestScope.Instance scopeInstance, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                ClientRuntime.this.requestScope.runInScope(scopeInstance, task);
            }
        });
    }

    private ClientRequest addUserAgent(ClientRequest clientRequest, String connectorName) {
        if (!clientRequest.getHeaders().containsKey("User-Agent")) {
            if (connectorName != null && !connectorName.equals("")) {
                clientRequest.getHeaders().put("User-Agent", Arrays.asList(String.format("Jersey/%s (%s)", Version.getVersion(), connectorName)));
            } else {
                clientRequest.getHeaders().put("User-Agent", Arrays.asList(String.format("Jersey/%s", Version.getVersion())));
            }
        }
        return clientRequest;
    }

    public ClientResponse invoke(ClientRequest request) throws ClientException {
        try {
            ClientResponse response;
            try {
                response = this.connector.apply(this.addUserAgent(Stages.process(request, this.requestProcessingRoot), this.connector.getName()));
            }
            catch (AbortException aborted) {
                response = aborted.getAbortResponse();
            }
            return Stages.process(response, this.responseProcessingRoot);
        }
        catch (ClientException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new ClientException(t.getMessage(), t);
        }
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public ExtendedConfig getConfig() {
        return this.config;
    }

    public void close() {
        this.connector.close();
    }

    public void preInitialize() {
        this.locator.getService(MessageBodyWorkers.class, new Annotation[0]);
    }
}

