/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;

class ContainerFilteringStage
extends AbstractChainableStage<ContainerRequest> {
    private ServiceLocator locator;
    private final Iterable<RankedProvider<ContainerRequestFilter>> requestFilters;
    private final Iterable<RankedProvider<ContainerResponseFilter>> responseFilters;
    private final Provider<RespondingContext> respondingContextFactory;

    private ContainerFilteringStage(Provider<RespondingContext> respondingContextFactory, ServiceLocator locator, Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
        this.respondingContextFactory = respondingContextFactory;
        this.locator = locator;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    @Override
    public Stage.Continuation<ContainerRequest> apply(ContainerRequest requestContext) {
        Iterable<ContainerRequestFilter> sortedRequestFilters;
        if (this.responseFilters == null) {
            RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
            sortedRequestFilters = Providers.sortRankedProviders(new RankedComparator(), this.requestFilters, rc.getBoundRequestFilters());
        } else {
            ((RespondingContext)this.respondingContextFactory.get()).push(new ResponseFilterStage(this.responseFilters, this.locator));
            sortedRequestFilters = Providers.sortRankedProviders(new RankedComparator(), this.requestFilters);
        }
        for (ContainerRequestFilter filter : sortedRequestFilters) {
            try {
                filter.filter(requestContext);
                final Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) continue;
                return Stage.Continuation.of(requestContext, Stages.asStage(new Endpoint(){

                    @Override
                    public ContainerResponse apply(ContainerRequest requestContext) {
                        return new ContainerResponse(requestContext, abortResponse);
                    }
                }));
            }
            catch (IOException ex) {
                Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) {
                    throw new WebApplicationException(ex);
                }
                throw new WebApplicationException((Throwable)ex, abortResponse);
            }
        }
        return Stage.Continuation.of(requestContext, this.getDefaultNext());
    }

    static class Binder
    extends AbstractBinder {
        Binder() {
        }

        @Override
        protected void configure() {
            this.bindAsContract(Builder.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ContainerResponse> {
        private final Iterable<RankedProvider<ContainerResponseFilter>> filters;
        private final ServiceLocator locator;

        private ResponseFilterStage(Iterable<RankedProvider<ContainerResponseFilter>> filters, ServiceLocator locator) {
            this.filters = filters;
            this.locator = locator;
        }

        @Override
        public Stage.Continuation<ContainerResponse> apply(ContainerResponse responseContext) {
            try {
                RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
                Iterable<ContainerResponseFilter> sortedResponseFilters = Providers.sortRankedProviders(new RankedComparator(RankedComparator.Order.DESCENDING), this.filters, rc.getBoundResponseFilters());
                for (ContainerResponseFilter filter : sortedResponseFilters) {
                    filter.filter(responseContext.getRequestContext(), responseContext);
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException(ex);
            }
            return Stage.Continuation.of(responseContext, this.getDefaultNext());
        }
    }

    static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        private Provider<RespondingContext> respondingContextFactory;

        Builder() {
        }

        public ContainerFilteringStage build(Iterable<RankedProvider<ContainerRequestFilter>> requestFilters, Iterable<RankedProvider<ContainerResponseFilter>> responseFilters) {
            return new ContainerFilteringStage(this.respondingContextFactory, this.locator, requestFilters, responseFilters);
        }
    }
}

