/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.MatchingEntityTag;
import org.glassfish.jersey.message.internal.VariantSelector;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.uri.UriComponent;

public class ContainerRequest
extends InboundMessageContext
implements ContainerRequestContext,
Request,
HttpHeaders {
    private static URI DEFAULT_BASE_URI = URI.create("/");
    private final PropertiesDelegate propertiesDelegate;
    private URI baseUri;
    private URI requestUri;
    private String encodedRelativePath = null;
    private String decodedRelativePath = null;
    private String httpMethod;
    private SecurityContext securityContext;
    private Response abortResponse;
    private String varyValue;
    private UriInfo uriInfo;
    private RequestScopedInitializer requestScopedInitializer;
    private ContainerResponseWriter responseWriter;

    private static URI normalizeBaseUri(URI baseUri) {
        return baseUri.normalize();
    }

    public ContainerRequest(URI baseUri, URI requestUri, String httpMethod, SecurityContext securityContext, PropertiesDelegate propertiesDelegate) {
        this.baseUri = baseUri == null ? DEFAULT_BASE_URI : ContainerRequest.normalizeBaseUri(baseUri);
        this.requestUri = requestUri.normalize();
        this.httpMethod = httpMethod;
        this.securityContext = securityContext;
        this.propertiesDelegate = propertiesDelegate;
    }

    public RequestScopedInitializer getRequestScopedInitializer() {
        return this.requestScopedInitializer;
    }

    public void setRequestScopedInitializer(RequestScopedInitializer requestScopedInitializer) {
        this.requestScopedInitializer = requestScopedInitializer;
    }

    public ContainerResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setWriter(ContainerResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public <T> T readEntity(Class<T> rawType) {
        return this.readEntity(rawType, this.propertiesDelegate);
    }

    public <T> T readEntity(Class<T> rawType, Annotation[] annotations) {
        return super.readEntity(rawType, annotations, this.propertiesDelegate);
    }

    public <T> T readEntity(Class<T> rawType, Type type) {
        return super.readEntity(rawType, type, this.propertiesDelegate);
    }

    public <T> T readEntity(Class<T> rawType, Type type, Annotation[] annotations) {
        return super.readEntity(rawType, type, annotations, this.propertiesDelegate);
    }

    @Override
    public Object getProperty(String name) {
        return this.propertiesDelegate.getProperty(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.propertiesDelegate.getPropertyNames();
    }

    @Override
    public void setProperty(String name, Object object) {
        this.propertiesDelegate.setProperty(name, object);
    }

    @Override
    public void removeProperty(String name) {
        this.propertiesDelegate.removeProperty(name);
    }

    public PropertiesDelegate getPropertiesDelegate() {
        return this.propertiesDelegate;
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    @Override
    public void setRequestUri(URI requestUri) throws IllegalStateException {
        if (!this.uriInfo.getMatchedURIs().isEmpty()) {
            throw new IllegalStateException("Method could be called only in pre-matching request filter.");
        }
        this.encodedRelativePath = null;
        this.decodedRelativePath = null;
        this.requestUri = requestUri;
    }

    @Override
    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        if (!this.uriInfo.getMatchedURIs().isEmpty()) {
            throw new IllegalStateException("Method could be called only in pre-matching request filter.");
        }
        this.baseUri = baseUri;
        this.requestUri = requestUri;
    }

    public String getPath(boolean decode) {
        if (decode) {
            if (this.decodedRelativePath != null) {
                return this.decodedRelativePath;
            }
            this.decodedRelativePath = UriComponent.decode(this.encodedRelativePath(), UriComponent.Type.PATH);
            return this.decodedRelativePath;
        }
        return this.encodedRelativePath();
    }

    private String encodedRelativePath() {
        String applicationRootUriRawPath;
        if (this.encodedRelativePath != null) {
            return this.encodedRelativePath;
        }
        String requestUriRawPath = this.requestUri.getRawPath();
        String result = this.baseUri == null ? requestUriRawPath : ((applicationRootUriRawPath = this.baseUri.getRawPath()).length() > requestUriRawPath.length() ? "" : requestUriRawPath.substring(applicationRootUriRawPath.length()));
        if (result.isEmpty()) {
            result = "/";
        }
        this.encodedRelativePath = result.charAt(0) == '/' ? result : '/' + result;
        return this.encodedRelativePath;
    }

    @Override
    public String getMethod() {
        return this.httpMethod;
    }

    @Override
    public void setMethod(String method) throws IllegalStateException {
        if (!this.uriInfo.getMatchedURIs().isEmpty()) {
            throw new IllegalStateException("Method could be called only in pre-matching request filter.");
        }
        this.httpMethod = method;
    }

    public void setMethodWithoutException(String method) {
        this.httpMethod = method;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    @Override
    public Request getRequest() {
        return this;
    }

    @Override
    public void abortWith(Response response) {
        this.abortResponse = response;
    }

    public Response getAbortResponse() {
        return this.abortResponse;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return super.getRequestCookies();
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        return Lists.transform(this.getQualifiedAcceptableMediaTypes(), (Function)new Function<AcceptableMediaType, MediaType>(){

            public MediaType apply(AcceptableMediaType input) {
                return input;
            }
        });
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        return Lists.transform(this.getQualifiedAcceptableLanguages(), (Function)new Function<AcceptableLanguageTag, Locale>(){

            public Locale apply(AcceptableLanguageTag input) {
                return input.getAsLocale();
            }
        });
    }

    @Override
    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL_OR_EMPTY("variants"));
        }
        Ref<String> varyValueRef = Refs.emptyRef();
        Variant variant = VariantSelector.selectVariant(this, variants, varyValueRef);
        this.varyValue = (String)varyValueRef.get();
        return variant;
    }

    public String getVaryValue() {
        return this.varyValue;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        if (eTag == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("eTag"));
        }
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r != null) {
            return r;
        }
        return this.evaluateIfNoneMatch(eTag);
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        if (lastModified == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("lastModified"));
        }
        long lastModifiedTime = lastModified.getTime();
        Response.ResponseBuilder r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r != null) {
            return r;
        }
        return this.evaluateIfModifiedSince(lastModifiedTime);
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("lastModified"));
        }
        if (eTag == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("eTag"));
        }
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r != null) {
            return r;
        }
        long lastModifiedTime = lastModified.getTime();
        r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r != null) {
            return r;
        }
        boolean isGetOrHead = this.getMethod().equals("GET") || this.getMethod().equals("HEAD");
        Set<MatchingEntityTag> matchingTags = this.getIfNoneMatch();
        if (matchingTags != null && (r = this.evaluateIfNoneMatch(eTag, matchingTags, isGetOrHead)) == null) {
            return r;
        }
        String ifModifiedSinceHeader = this.getHeaderString("If-Modified-Since");
        if (ifModifiedSinceHeader != null && ifModifiedSinceHeader.length() > 0 && isGetOrHead && (r = this.evaluateIfModifiedSince(lastModifiedTime, ifModifiedSinceHeader)) != null) {
            r.tag(eTag);
        }
        return r;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions() {
        Set<MatchingEntityTag> matchingTags = this.getIfMatch();
        if (matchingTags == null) {
            return null;
        }
        return Response.status(Response.Status.PRECONDITION_FAILED);
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        Set<MatchingEntityTag> matchingTags = this.getIfMatch();
        if (matchingTags == null) {
            return null;
        }
        if (eTag.isWeak()) {
            return Response.status(Response.Status.PRECONDITION_FAILED);
        }
        if (matchingTags != MatchingEntityTag.ANY_MATCH && !matchingTags.contains(eTag)) {
            return Response.status(Response.Status.PRECONDITION_FAILED);
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag) {
        Set<MatchingEntityTag> matchingTags = this.getIfNoneMatch();
        if (matchingTags == null) {
            return null;
        }
        String httpMethod = this.getMethod();
        return this.evaluateIfNoneMatch(eTag, matchingTags, httpMethod.equals("GET") || httpMethod.equals("HEAD"));
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag, Set<? super MatchingEntityTag> matchingTags, boolean isGetOrHead) {
        if (isGetOrHead) {
            if (matchingTags == MatchingEntityTag.ANY_MATCH) {
                return Response.notModified(eTag);
            }
            if (matchingTags.contains(eTag) || matchingTags.contains(new EntityTag(eTag.getValue(), !eTag.isWeak()))) {
                return Response.notModified(eTag);
            }
        } else {
            if (eTag.isWeak()) {
                return null;
            }
            if (matchingTags == MatchingEntityTag.ANY_MATCH || matchingTags.contains(eTag)) {
                return Response.status(Response.Status.PRECONDITION_FAILED);
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(long lastModified) {
        String ifUnmodifiedSinceHeader = this.getHeaderString("If-Unmodified-Since");
        if (ifUnmodifiedSinceHeader != null && ifUnmodifiedSinceHeader.length() > 0) {
            try {
                long ifUnmodifiedSince = HttpHeaderReader.readDate(ifUnmodifiedSinceHeader).getTime();
                if (ContainerRequest.roundDown(lastModified) > ifUnmodifiedSince) {
                    return Response.status(Response.Status.PRECONDITION_FAILED);
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified) {
        String ifModifiedSinceHeader = this.getHeaderString("If-Modified-Since");
        if (ifModifiedSinceHeader == null || ifModifiedSinceHeader.length() == 0) {
            return null;
        }
        String httpMethod = this.getMethod();
        if (httpMethod.equals("GET") || httpMethod.equals("HEAD")) {
            return this.evaluateIfModifiedSince(lastModified, ifModifiedSinceHeader);
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified, String ifModifiedSinceHeader) {
        try {
            long ifModifiedSince = HttpHeaderReader.readDate(ifModifiedSinceHeader).getTime();
            if (ContainerRequest.roundDown(lastModified) <= ifModifiedSince) {
                return Response.notModified();
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return null;
    }

    private static long roundDown(long time) {
        return time - time % 1000L;
    }

    @Override
    public List<String> getRequestHeader(String name) {
        return (List)this.getHeaders().get(name);
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.getHeaders();
    }

    void checkState() throws IllegalStateException {
        if (this.securityContext == null) {
            throw new IllegalStateException("SecurityContext set in the ContainerRequestContext must not be null.");
        }
        if (this.responseWriter == null) {
            throw new IllegalStateException("ResponseWriter set in the ContainerRequestContext must not be null.");
        }
    }
}

