/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.MethodSelectingRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedMethodResourceRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedRuntimeResourceRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedUriRouter;
import org.glassfish.jersey.server.internal.routing.PushMethodHandlerRouter;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RouterBinder;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.internal.routing.SubResourceLocatorRouter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.server.model.RuntimeResourceModel;
import org.glassfish.jersey.uri.PathPattern;

public final class RuntimeModelBuilder {
    private final RouterBinder.RootRouteBuilder<PathPattern> rootBuilder;
    private final ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    private final ServiceLocator locator;
    private final PushMethodHandlerRouter.Builder pushHandlerAcceptorBuilder;
    private final MethodSelectingRouter.Builder methodSelectingAcceptorBuilder;
    private final MessageBodyWorkers workers;
    private final PushMatchedMethodResourceRouter.Builder pushedMatchedMethodResourceBuilder;
    private final PushMatchedRuntimeResourceRouter.Builder pushedMatchedRuntimeResourceBuilder;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters;
    private Iterable<RankedProvider<ReaderInterceptor>> globalReaderInterceptors;
    private Iterable<RankedProvider<WriterInterceptor>> globalWriterInterceptors;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors;
    private MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors;
    private Iterable<DynamicFeature> dynamicFeatures;

    @Inject
    public RuntimeModelBuilder(RouterBinder.RootRouteBuilder<PathPattern> rootBuilder, ResourceMethodInvoker.Builder resourceMethodInvokerBuilder, ServiceLocator locator, PushMethodHandlerRouter.Builder pushHandlerAcceptorBuilder, MethodSelectingRouter.Builder methodSelectingAcceptorBuilder, PushMatchedMethodResourceRouter.Builder pushedMatchedMethodResourceBuilder, PushMatchedRuntimeResourceRouter.Builder pushedMatchedRuntimeResourceBuilder, MessageBodyWorkers workers) {
        this.rootBuilder = rootBuilder;
        this.resourceMethodInvokerBuilder = resourceMethodInvokerBuilder;
        this.locator = locator;
        this.pushHandlerAcceptorBuilder = pushHandlerAcceptorBuilder;
        this.methodSelectingAcceptorBuilder = methodSelectingAcceptorBuilder;
        this.workers = workers;
        this.pushedMatchedMethodResourceBuilder = pushedMatchedMethodResourceBuilder;
        this.pushedMatchedRuntimeResourceBuilder = pushedMatchedRuntimeResourceBuilder;
    }

    private Router createSingleMethodAcceptor(ResourceMethod resourceMethod) {
        Router methodAcceptor = null;
        switch (resourceMethod.getType()) {
            case RESOURCE_METHOD: 
            case SUB_RESOURCE_METHOD: {
                methodAcceptor = Routers.asTreeAcceptor(this.createInflector(resourceMethod));
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                methodAcceptor = new SubResourceLocatorRouter(this.locator, this, resourceMethod);
            }
        }
        return this.pushHandlerAcceptorBuilder.build(resourceMethod.getInvocable().getHandler(), methodAcceptor);
    }

    private Inflector<ContainerRequest, ContainerResponse> createInflector(ResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method, this.nameBoundRequestFilters, this.nameBoundResponseFilters, this.globalReaderInterceptors, this.globalWriterInterceptors, this.nameBoundReaderInterceptors, this.nameBoundWriterInterceptors, this.dynamicFeatures);
    }

    private Router createRootTreeAcceptor(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder, boolean subResourceMode) {
        Router routingRoot = lastRoutedBuilder != null ? lastRoutedBuilder.build() : Routers.acceptingTree(new Function<ContainerRequest, ContainerRequest>(){

            public ContainerRequest apply(ContainerRequest input) {
                return input;
            }
        }).build();
        if (subResourceMode) {
            return routingRoot;
        }
        return this.rootBuilder.root(routingRoot);
    }

    private RouterBinder.RouteToPathBuilder<PathPattern> routeMethodAcceptor(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder, PathPattern pathPattern, PushMatchedUriRouter uriPushingAcceptor, PushMatchedRuntimeResourceRouter resourcePushingRouter, Router methodAcceptor, boolean subResourceMode) {
        if (subResourceMode) {
            return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(resourcePushingRouter).to(methodAcceptor);
        }
        return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(uriPushingAcceptor).to(resourcePushingRouter).to(methodAcceptor);
    }

    public Router buildModel(RuntimeResourceModel resourceModel, boolean subResourceMode) {
        List<RuntimeResource> runtimeResources = resourceModel.getRuntimeResources();
        PushMatchedUriRouter uriPushingRouter = (PushMatchedUriRouter)this.locator.createAndInitialize(PushMatchedUriRouter.class);
        RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder = null;
        for (RuntimeResource resource : runtimeResources) {
            PushMatchedRuntimeResourceRouter resourcePushingRouter = this.pushedMatchedRuntimeResourceBuilder.build(resource);
            if (resource.getResourceMethods().size() > 0) {
                List<MethodAcceptorPair> methodAcceptors = this.createAcceptors(resource, subResourceMode);
                PathPattern resourceClosedPattern = subResourceMode ? PathPattern.END_OF_PATH_PATTERN : PathPattern.asClosed(resource.getPathPattern());
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, resourceClosedPattern, uriPushingRouter, resourcePushingRouter, this.methodSelectingAcceptorBuilder.build(this.workers, methodAcceptors), subResourceMode);
            }
            RouterBinder.RouteToPathBuilder<PathPattern> srRoutedBuilder = null;
            if (resource.getChildRuntimeResources().size() > 0) {
                for (RuntimeResource child : resource.getChildRuntimeResources()) {
                    PathPattern childOpenPattern = child.getPathPattern();
                    PathPattern childClosedPattern = PathPattern.asClosed(childOpenPattern);
                    PushMatchedRuntimeResourceRouter childResourcePushingRouter = this.pushedMatchedRuntimeResourceBuilder.build(child);
                    if (child.getResourceMethods().size() > 0) {
                        List<MethodAcceptorPair> childMethodAcceptors = this.createAcceptors(child, subResourceMode);
                        srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(childClosedPattern).to(uriPushingRouter).to(childResourcePushingRouter).to(this.methodSelectingAcceptorBuilder.build(this.workers, childMethodAcceptors));
                    }
                    if (child.getResourceLocator() == null) continue;
                    srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(childOpenPattern).to(uriPushingRouter).to(childResourcePushingRouter).to(this.createSingleMethodAcceptor(child.getResourceLocator()));
                }
            }
            if (resource.getResourceLocator() != null) {
                srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(PathPattern.OPEN_ROOT_PATH_PATTERN).to(uriPushingRouter).to(this.createSingleMethodAcceptor(resource.getResourceLocator()));
            }
            if (srRoutedBuilder == null) continue;
            PathPattern resourceOpenPattern = subResourceMode ? PathPattern.OPEN_ROOT_PATH_PATTERN : resource.getPathPattern();
            lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, resourceOpenPattern, uriPushingRouter, resourcePushingRouter, srRoutedBuilder.build(), subResourceMode);
        }
        return this.createRootTreeAcceptor(lastRoutedBuilder, subResourceMode);
    }

    private List<MethodAcceptorPair> createAcceptors(RuntimeResource runtimeResource, boolean subResourceMode) {
        ArrayList acceptorPairList = Lists.newArrayList();
        for (Resource resource : runtimeResource.getResources()) {
            for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
                acceptorPairList.add(new MethodAcceptorPair(resourceMethod, this.pushedMatchedMethodResourceBuilder.build(resource, resourceMethod), this.createSingleMethodAcceptor(resourceMethod)));
            }
        }
        return acceptorPairList;
    }

    private RouterBinder.RouteBuilder<PathPattern> routedBuilder(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        return lastRoutedBuilder == null ? this.rootBuilder : lastRoutedBuilder;
    }

    public void setGlobalInterceptors(Iterable<RankedProvider<ReaderInterceptor>> readerInterceptors, Iterable<RankedProvider<WriterInterceptor>> writerInterceptors) {
        this.globalReaderInterceptors = readerInterceptors;
        this.globalWriterInterceptors = writerInterceptors;
    }

    public void setBoundProviders(MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors, Iterable<DynamicFeature> dynamicFeatures) {
        this.nameBoundRequestFilters = nameBoundRequestFilters;
        this.nameBoundResponseFilters = nameBoundResponseFilters;
        this.nameBoundReaderInterceptors = nameBoundReaderInterceptors;
        this.nameBoundWriterInterceptors = nameBoundWriterInterceptors;
        this.dynamicFeatures = dynamicFeatures;
    }
}

