/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.TemplateHelper;
import org.glassfish.jersey.server.mvc.spi.ResolvedViewable;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;
import org.glassfish.jersey.server.mvc.spi.ViewableContext;
import org.glassfish.jersey.server.mvc.spi.ViewableContextException;

class ResolvingViewableContext
implements ViewableContext {
    ResolvingViewableContext() {
    }

    @Override
    public ResolvedViewable resolveViewable(Viewable viewable, MediaType mediaType, Class<?> resolvingClass, TemplateProcessor templateProcessor) {
        if (viewable.isTemplateNameAbsolute()) {
            return this.resolveAbsoluteViewable(viewable, mediaType, templateProcessor);
        }
        if (viewable.getResolvingClass() != null) {
            return this.resolveRelativeViewable(viewable, viewable.getResolvingClass(), mediaType, templateProcessor);
        }
        if (resolvingClass == null) {
            throw new ViewableContextException(LocalizationMessages.TEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL());
        }
        return this.resolveRelativeViewable(viewable, resolvingClass, mediaType, templateProcessor);
    }

    private ResolvedViewable resolveAbsoluteViewable(Viewable viewable, MediaType mediaType, TemplateProcessor templateProcessor) {
        Object resolvedTemplateObject = templateProcessor.resolve(viewable.getTemplateName(), mediaType);
        if (resolvedTemplateObject != null) {
            return new ResolvedViewable(templateProcessor, resolvedTemplateObject, viewable, mediaType);
        }
        return null;
    }

    private ResolvedViewable resolveRelativeViewable(Viewable viewable, Class<?> resolvingClass, MediaType mediaType, TemplateProcessor templateProcessor) {
        Object resolvedTemplateObject;
        String absolutePath;
        Class<?> c;
        String path = TemplateHelper.getTemplateName(viewable);
        for (c = resolvingClass; c != Object.class; c = c.getSuperclass()) {
            absolutePath = TemplateHelper.getAbsolutePath(c, path, '/');
            resolvedTemplateObject = templateProcessor.resolve(absolutePath, mediaType);
            if (resolvedTemplateObject == null) continue;
            return new ResolvedViewable(templateProcessor, resolvedTemplateObject, viewable, c, mediaType);
        }
        for (c = resolvingClass; c != Object.class; c = c.getSuperclass()) {
            absolutePath = TemplateHelper.getAbsolutePath(c, path, '.');
            resolvedTemplateObject = templateProcessor.resolve(absolutePath, mediaType);
            if (resolvedTemplateObject == null) continue;
            return new ResolvedViewable(templateProcessor, resolvedTemplateObject, viewable, c, mediaType);
        }
        return null;
    }
}

