/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.VariantSelector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;

public final class TemplateHelper {
    public static String getAbsolutePath(Class<?> resourceClass, String path, char delim) {
        return '/' + resourceClass.getName().replace('.', '/').replace('$', delim) + delim + path;
    }

    public static List<MediaType> getProducibleMediaTypes(ContainerRequest containerRequest, ExtendedUriInfo extendedUriInfo, Ref<String> varyHeaderValue) {
        List<MediaType> producedTypes = TemplateHelper.getResourceMethodProducibleTypes(extendedUriInfo);
        MediaType[] mediaTypes = producedTypes.toArray(new MediaType[producedTypes.size()]);
        List<Variant> variants = VariantSelector.selectVariants(containerRequest, Variant.mediaTypes(mediaTypes).build(), varyHeaderValue == null ? Refs.emptyRef() : varyHeaderValue);
        return Lists.transform(variants, (Function)new Function<Variant, MediaType>(){

            public MediaType apply(Variant variant) {
                return MediaTypes.stripQualityParams(variant.getMediaType());
            }
        });
    }

    public static String getTemplateName(Viewable viewable) {
        return viewable.getTemplateName() == null || viewable.getTemplateName().isEmpty() ? "index" : viewable.getTemplateName();
    }

    private static List<MediaType> getResourceMethodProducibleTypes(ExtendedUriInfo extendedUriInfo) {
        if (extendedUriInfo.getMatchedResourceMethod() != null && !extendedUriInfo.getMatchedResourceMethod().getProducedTypes().isEmpty()) {
            return extendedUriInfo.getMatchedResourceMethod().getProducedTypes();
        }
        return Arrays.asList(MediaType.WILDCARD_TYPE);
    }

    public static Template getTemplateAnnotation(Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Template)) continue;
                return (Template)annotation;
            }
        }
        return null;
    }

    private TemplateHelper() {
    }
}

