/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.mvc.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.DefaultTemplateProcessor;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.mvc.internal.RequestDispatcherWrapper;

public class JspTemplateProcessor
extends DefaultTemplateProcessor<String> {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(JspTemplateProcessor.class.getName()), Level.FINEST);
    @Context
    private HttpContext httpContext;
    @Context
    private ServletContext servletContext;
    @Inject
    private Provider<Ref<HttpServletRequest>> requestProviderRef;
    @Inject
    private Provider<Ref<HttpServletResponse>> responseProviderRef;

    public JspTemplateProcessor(@Context Configuration config) {
        super(config);
        this.setBasePathFromProperty("jersey.config.servlet.JspTemplatesBasePath");
    }

    @Override
    public String resolve(String name, MediaType mediaType) {
        if (this.servletContext == null) {
            return null;
        }
        try {
            for (String templateName : this.getPossibleTemplateNames(name)) {
                if (this.servletContext.getResource(templateName) == null) continue;
                return templateName;
            }
        }
        catch (MalformedURLException ex) {
            logger.log(Level.FINE, LocalizationMessages.RESOURCE_PATH_NOT_IN_CORRECT_FORM(this.getTemplateName(name)));
        }
        return null;
    }

    @Override
    protected List<String> getExtensions() {
        return Lists.newArrayList((Object[])new String[]{".jsp"});
    }

    @Override
    public void writeTo(String templateReference, Viewable viewable, MediaType mediaType, final OutputStream out) throws IOException {
        RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(templateReference);
        if (dispatcher == null) {
            throw new ContainerException(LocalizationMessages.NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(templateReference));
        }
        dispatcher = new RequestDispatcherWrapper(dispatcher, this.getBasePath(), this.httpContext, viewable);
        final ServletOutputStream responseStream = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        final PrintWriter responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)responseStream));
        try {
            dispatcher.forward((ServletRequest)((Ref)this.requestProviderRef.get()).get(), (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)((Ref)this.responseProviderRef.get()).get()){

                public ServletOutputStream getOutputStream() throws IOException {
                    return responseStream;
                }

                public PrintWriter getWriter() throws IOException {
                    return responseWriter;
                }
            });
        }
        catch (Exception e) {
            throw new ContainerException(e);
        }
        finally {
            responseWriter.flush();
        }
    }
}

