/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;

public class JerseyClient
implements Client {
    private final AtomicBoolean closedFlag = new AtomicBoolean(false);
    private final ClientConfig config;
    private final HostnameVerifier hostnameVerifier;
    private final SSLContext sslContext;
    private final LinkedBlockingDeque<LifecycleListener> listeners = new LinkedBlockingDeque();

    protected JerseyClient() {
        this.config = new ClientConfig(this);
        this.hostnameVerifier = null;
        this.sslContext = SslConfigurator.getDefaultContext();
    }

    protected JerseyClient(Configuration config, SSLContext sslContext, HostnameVerifier verifier) {
        this.config = config == null ? new ClientConfig(this) : new ClientConfig(this, config);
        this.sslContext = sslContext == null ? SslConfigurator.getDefaultContext() : sslContext;
        this.hostnameVerifier = verifier;
    }

    @Override
    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
        LifecycleListener listener;
        while ((listener = this.listeners.pollFirst()) != null) {
            listener.onClose();
        }
    }

    public void addListener(LifecycleListener listener) {
        this.checkNotClosed();
        this.listeners.push(listener);
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    void checkNotClosed() throws IllegalStateException {
        Preconditions.checkState((!this.closedFlag.get() ? 1 : 0) != 0, (Object)"Client instance has been closed.");
    }

    @Override
    public JerseyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)"URI template of the newly created target must not be 'null'.");
        return new JerseyWebTarget(uri, this);
    }

    @Override
    public JerseyWebTarget target(URI uri) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)"URI of the newly created target must not be 'null'.");
        return new JerseyWebTarget(uri, this);
    }

    @Override
    public JerseyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uriBuilder, (Object)"URI builder of the newly created target must not be 'null'.");
        return new JerseyWebTarget(uriBuilder, this);
    }

    @Override
    public JerseyWebTarget target(Link link) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link to the newly created target must not be 'null'.");
        return new JerseyWebTarget(link, this);
    }

    @Override
    public JerseyInvocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link of the newly created invocation must not be 'null'.");
        JerseyWebTarget t = new JerseyWebTarget(link, this);
        String acceptType = link.getType();
        return acceptType != null ? t.request(acceptType) : t.request();
    }

    @Override
    public JerseyClient register(Class<?> providerClass) {
        this.checkNotClosed();
        this.config.register((Class)providerClass);
        return this;
    }

    @Override
    public JerseyClient register(Object provider) {
        this.checkNotClosed();
        this.config.register(provider);
        return this;
    }

    @Override
    public JerseyClient register(Class<?> providerClass, int bindingPriority) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, bindingPriority);
        return this;
    }

    @Override
    public JerseyClient register(Class<?> providerClass, Class<?> ... contracts) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, (Class[])contracts);
        return this;
    }

    @Override
    public JerseyClient register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, (Map)contracts);
        return this;
    }

    @Override
    public JerseyClient register(Object provider, int bindingPriority) {
        this.checkNotClosed();
        this.config.register(provider, bindingPriority);
        return this;
    }

    @Override
    public JerseyClient register(Object provider, Class<?> ... contracts) {
        this.checkNotClosed();
        this.config.register(provider, (Class[])contracts);
        return this;
    }

    @Override
    public JerseyClient register(Object provider, Map<Class<?>, Integer> contracts) {
        this.checkNotClosed();
        this.config.register(provider, (Map)contracts);
        return this;
    }

    @Override
    public JerseyClient property(String name, Object value) {
        this.checkNotClosed();
        this.config.property(name, value);
        return this;
    }

    @Override
    public ClientConfig getConfiguration() {
        this.checkNotClosed();
        return this.config.getConfiguration();
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public JerseyClient preInitialize() {
        this.config.preInitialize();
        return this;
    }

    static interface LifecycleListener {
        public void onClose();
    }
}

