/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.util.Closure;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ChunkedOutput;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.spi.ExceptionMappers;

class ServerRuntime {
    private final Stage<ContainerRequest> requestProcessingRoot;
    private final ServiceLocator locator;
    private final RequestScope requestScope;
    private final ExceptionMappers exceptionMappers;
    private final Provider<CloseableService> closeableServiceProvider;
    private final Provider<Ref<Value<AsyncContext>>> asyncContextFactoryProvider;
    private final Provider<AsyncContext> asyncContextProvider;
    private final ExecutorsFactory<ContainerRequest> asyncExecutorsFactory;
    private final Configuration configuration;
    private static final Logger LOGGER = Logger.getLogger(ServerRuntime.class.getName());

    private ServerRuntime(Stage<ContainerRequest> requestProcessingRoot, ServiceLocator locator, RequestScope requestScope, ExceptionMappers exceptionMappers, Provider<CloseableService> closeableServiceProvider, Provider<Ref<Value<AsyncContext>>> asyncContextFactoryProvider, Provider<AsyncContext> asyncContextProvider, ExecutorsFactory<ContainerRequest> asyncExecutorsFactory, Configuration configuration) {
        this.requestProcessingRoot = requestProcessingRoot;
        this.locator = locator;
        this.requestScope = requestScope;
        this.exceptionMappers = exceptionMappers;
        this.closeableServiceProvider = closeableServiceProvider;
        this.asyncContextFactoryProvider = asyncContextFactoryProvider;
        this.asyncContextProvider = asyncContextProvider;
        this.asyncExecutorsFactory = asyncExecutorsFactory;
        this.configuration = configuration;
    }

    public void process(final ContainerRequest request) {
        request.checkState();
        this.requestScope.runInScope(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Responder responder = new Responder(request, (RespondingContext)ServerRuntime.this.locator.getService(RespondingContext.class, new Annotation[0]), ServerRuntime.this.exceptionMappers, (Provider<CloseableService>)ServerRuntime.this.closeableServiceProvider, (Provider<AsyncContext>)ServerRuntime.this.asyncContextProvider, ServerRuntime.this.configuration);
                AsyncResponderHolder asyncResponderHolder = new AsyncResponderHolder(responder, ServerRuntime.this.locator, ServerRuntime.this.requestScope, ServerRuntime.this.requestScope.referenceCurrent(), ServerRuntime.this.asyncExecutorsFactory);
                try {
                    Ref endpointRef = Refs.emptyRef();
                    ContainerRequest data = Stages.process(request, ServerRuntime.this.requestProcessingRoot, endpointRef);
                    Endpoint endpoint = (Endpoint)endpointRef.get();
                    if (endpoint == null) {
                        throw new NotFoundException();
                    }
                    ((Ref)ServerRuntime.this.asyncContextFactoryProvider.get()).set(asyncResponderHolder);
                    ContainerResponse response = (ContainerResponse)endpoint.apply(data);
                    if (!asyncResponderHolder.isAsync()) {
                        responder.process(response);
                    }
                }
                catch (Throwable throwable) {
                    responder.process(throwable);
                }
                finally {
                    asyncResponderHolder.release();
                }
            }
        });
    }

    static class ConnectionCallbackRunner
    extends AbstractCallbackRunner<ConnectionCallback>
    implements ConnectionCallback {
        private ConnectionCallbackRunner() {
            super(Logger.getLogger(ConnectionCallbackRunner.class.getName()));
        }

        @Override
        public Class<?> getCallbackContract() {
            return ConnectionCallback.class;
        }

        @Override
        public void onDisconnect(final AsyncResponse disconnected) {
            this.executeCallbacks(new Closure<ConnectionCallback>(){

                @Override
                public void invoke(ConnectionCallback callback) {
                    callback.onDisconnect(disconnected);
                }
            });
        }
    }

    private static class CompletionCallbackRunner
    extends AbstractCallbackRunner<CompletionCallback>
    implements CompletionCallback {
        private CompletionCallbackRunner() {
            super(Logger.getLogger(CompletionCallbackRunner.class.getName()));
        }

        @Override
        public Class<?> getCallbackContract() {
            return CompletionCallback.class;
        }

        @Override
        public void onComplete(final Throwable throwable) {
            this.executeCallbacks(new Closure<CompletionCallback>(){

                @Override
                public void invoke(CompletionCallback callback) {
                    callback.onComplete(throwable);
                }
            });
        }
    }

    private static abstract class AbstractCallbackRunner<T> {
        private final Queue<T> callbacks = new ConcurrentLinkedQueue<T>();
        private final Logger logger;

        protected AbstractCallbackRunner(Logger logger) {
            this.logger = logger;
        }

        public final boolean supports(Class<?> callbackClass) {
            return this.getCallbackContract().isAssignableFrom(callbackClass);
        }

        public abstract Class<?> getCallbackContract();

        public boolean register(Object callback) {
            return this.callbacks.offer(callback);
        }

        protected final void executeCallbacks(Closure<T> invoker) {
            for (Object callback : this.callbacks) {
                try {
                    invoker.invoke(callback);
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, LocalizationMessages.ERROR_ASYNC_CALLBACK_FAILED(callback.getClass().getName()), t);
                }
            }
        }
    }

    private static class AsyncResponder
    implements AsyncContext,
    ContainerResponseWriter.TimeoutHandler,
    CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(AsyncResponder.class.getName());
        private static final TimeoutHandler DEFAULT_TIMEOUT_HANDLER = new TimeoutHandler(){

            @Override
            public void handleTimeout(AsyncResponse asyncResponse) {
                throw new ServiceUnavailableException();
            }
        };
        private final Object stateLock = new Object();
        private AsyncContext.State state = AsyncContext.State.RUNNING;
        private boolean cancelled = false;
        private final Responder responder;
        private final ServiceLocator locator;
        private final RequestScope requestScope;
        private final RequestScope.Instance scopeInstance;
        private final ExecutorsFactory<ContainerRequest> asyncExecutorsFactory;
        private volatile TimeoutHandler timeoutHandler = DEFAULT_TIMEOUT_HANDLER;
        private final List<AbstractCallbackRunner<?>> callbackRunners;

        public AsyncResponder(Responder responder, ServiceLocator locator, RequestScope requestScope, RequestScope.Instance scopeInstance, ExecutorsFactory<ContainerRequest> asyncExecutorsFactory) {
            this.requestScope = requestScope;
            this.responder = responder;
            this.locator = locator;
            this.scopeInstance = scopeInstance;
            this.asyncExecutorsFactory = asyncExecutorsFactory;
            this.callbackRunners = Collections.unmodifiableList(Arrays.asList(responder.completionCallbackRunner, responder.connectionCallbackRunner));
            responder.completionCallbackRunner.register(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout(ContainerResponseWriter responseWriter) {
            TimeoutHandler handler = this.timeoutHandler;
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.state == AsyncContext.State.SUSPENDED) {
                        handler.handleTimeout(this);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.resume(throwable);
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(Throwable throwable) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = AsyncContext.State.COMPLETED;
            }
        }

        @Override
        public void invokeManaged(final Producer<Response> producer) {
            this.asyncExecutorsFactory.getRequestingExecutor(this.responder.request).submit(new Runnable(){

                @Override
                public void run() {
                    AsyncResponder.this.requestScope.runInScope(AsyncResponder.this.scopeInstance, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Response response = (Response)producer.call();
                                if (response != null) {
                                    AsyncResponder.this.resume(response);
                                }
                            }
                            catch (Throwable t) {
                                AsyncResponder.this.resume(t);
                            }
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend() {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == AsyncContext.State.RUNNING) {
                    this.state = AsyncContext.State.SUSPENDED;
                    this.responder.request.getResponseWriter().suspend(0L, TimeUnit.SECONDS, this);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean resume(final Object response) throws IllegalStateException {
            return this.resume(new Runnable(){

                @Override
                public void run() {
                    try {
                        Response jaxrsResponse = AsyncResponder.this.toJaxrsResponse(response);
                        AsyncResponder.this.responder.process(new ContainerResponse(AsyncResponder.this.responder.request, jaxrsResponse));
                    }
                    catch (Throwable t) {
                        AsyncResponder.this.responder.process(t);
                    }
                }
            });
        }

        private Response toJaxrsResponse(Object response) {
            if (response instanceof Response) {
                return (Response)response;
            }
            return Response.ok(response).build();
        }

        @Override
        public boolean resume(final Throwable error) throws IllegalStateException {
            return this.resume(new Runnable(){

                @Override
                public void run() {
                    AsyncResponder.this.responder.process(error);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resume(Runnable handler) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state != AsyncContext.State.SUSPENDED) {
                    return false;
                }
                this.state = AsyncContext.State.RESUMED;
            }
            this.requestScope.runInScope(this.scopeInstance, handler);
            return true;
        }

        @Override
        public boolean cancel() {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).build();
                }
            });
        }

        @Override
        public boolean cancel(final int retryAfter) {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build();
                }
            });
        }

        @Override
        public boolean cancel(final Date retryAfter) {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancel(final Value<Response> responseValue) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (this.state != AsyncContext.State.SUSPENDED) {
                    return false;
                }
                this.state = AsyncContext.State.RESUMED;
                this.cancelled = true;
            }
            this.requestScope.runInScope(this.scopeInstance, new Runnable(){

                @Override
                public void run() {
                    try {
                        Response response = (Response)responseValue.get();
                        AsyncResponder.this.responder.process(new ContainerResponse(AsyncResponder.this.responder.request, response));
                    }
                    catch (Throwable t) {
                        AsyncResponder.this.responder.process(t);
                    }
                }
            });
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.RUNNING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuspended() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.SUSPENDED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.cancelled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.COMPLETED;
            }
        }

        @Override
        public boolean setTimeout(long time, TimeUnit unit) {
            try {
                this.responder.request.getResponseWriter().setSuspendTimeout(time, unit);
                return true;
            }
            catch (IllegalStateException ex) {
                LOGGER.log(Level.FINER, "Unable to set timeout on the AsyncResponse.", ex);
                return false;
            }
        }

        @Override
        public void setTimeoutHandler(TimeoutHandler handler) {
            this.timeoutHandler = handler;
        }

        @Override
        public Collection<Class<?>> register(Class<?> callback) {
            return this.register(Injections.getOrCreate(this.locator, callback));
        }

        @Override
        public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
            HashMap results = new HashMap();
            results.put(callback, this.register(callback));
            if (callbacks != null) {
                for (Class<?> c : callbacks) {
                    results.put(c, this.register(c));
                }
            }
            return results;
        }

        @Override
        public Collection<Class<?>> register(Object callback) {
            LinkedList result = new LinkedList();
            for (AbstractCallbackRunner<?> runner : this.callbackRunners) {
                if (!runner.supports(callback.getClass()) || !runner.register(callback)) continue;
                result.add(runner.getCallbackContract());
            }
            return result;
        }

        @Override
        public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
            HashMap results = new HashMap();
            results.put(callback.getClass(), this.register(callback));
            if (callbacks != null) {
                for (Object c : callbacks) {
                    results.put(c.getClass(), this.register(c));
                }
            }
            return results;
        }
    }

    private static class Responder {
        private static final Logger LOGGER = Logger.getLogger(Responder.class.getName());
        private final ContainerRequest request;
        private final RespondingContext respondingCtx;
        private final ExceptionMappers exceptionMappers;
        private final Provider<CloseableService> closeableService;
        private final Provider<AsyncContext> asyncContext;
        private final Configuration configuration;
        private final CompletionCallbackRunner completionCallbackRunner = new CompletionCallbackRunner();
        private final ConnectionCallbackRunner connectionCallbackRunner = new ConnectionCallbackRunner();

        public Responder(ContainerRequest request, RespondingContext respondingCtx, ExceptionMappers exceptionMappers, Provider<CloseableService> closeableService, Provider<AsyncContext> asyncContext, Configuration configuration) {
            this.request = request;
            this.respondingCtx = respondingCtx;
            this.exceptionMappers = exceptionMappers;
            this.closeableService = closeableService;
            this.asyncContext = asyncContext;
            this.configuration = configuration;
        }

        public void process(ContainerResponse response) {
            response = this.processResponse(response);
            this.release(response);
        }

        private ContainerResponse processResponse(ContainerResponse response) {
            Stage<ContainerResponse> respondingRoot = this.respondingCtx.createRespondingRoot();
            if (respondingRoot != null) {
                response = Stages.process(response, respondingRoot);
            }
            this.writeResponse(response);
            this.completionCallbackRunner.onComplete(null);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Throwable throwable) {
            ContainerResponse response = null;
            try {
                response = this.convertResponse(this.mapException(throwable));
                this.processResponse(response);
                this.release(response);
            }
            catch (Throwable error) {
                try {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_EXCEPTION_NON_MAPPABLE(), error);
                    try {
                        this.request.getResponseWriter().failure(error);
                    }
                    finally {
                        this.completionCallbackRunner.onComplete(error);
                    }
                    this.release(response);
                }
                catch (Throwable throwable2) {
                    this.release(response);
                    throw throwable2;
                }
            }
        }

        private ContainerResponse convertResponse(Response exceptionResponse) {
            ContainerResponse containerResponse = new ContainerResponse(this.request, exceptionResponse);
            containerResponse.setMappedFromException(true);
            return containerResponse;
        }

        private Response mapException(Throwable throwable) throws Throwable {
            ExceptionMapper<?> mapper;
            if (throwable instanceof MappableException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof ProcessingException) {
                Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
                String message = throwable.getMessage();
                if (throwable instanceof HeaderValueException) {
                    statusCode = Response.Status.BAD_REQUEST;
                } else if (throwable instanceof ExtractorException) {
                    statusCode = Response.Status.BAD_REQUEST;
                }
                if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
                    LOGGER.log(Level.SEVERE, message, throwable);
                } else {
                    LOGGER.log(Level.FINE, message, throwable);
                }
                return Response.status((Response.StatusType)statusCode).build();
            }
            Response response = null;
            if (throwable instanceof WebApplicationException) {
                response = ((WebApplicationException)throwable).getResponse();
            }
            if (!(response != null && response.hasEntity() || (mapper = this.exceptionMappers.find(throwable.getClass())) == null)) {
                try {
                    response = mapper.toResponse(throwable);
                    if (response == null) {
                        return Response.noContent().build();
                    }
                }
                catch (Throwable t) {
                    return Response.serverError().build();
                }
            }
            if (response != null) {
                return response;
            }
            throw throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ContainerResponse writeResponse(final ContainerResponse response) {
            block32: {
                final ContainerResponseWriter writer = this.request.getResponseWriter();
                if (!response.hasEntity()) {
                    writer.writeResponseStatusAndHeaders(0L, response);
                    return response;
                }
                Object entity = response.getEntity();
                boolean skipFinally = false;
                final boolean isHead = this.request.getMethod().equals("HEAD");
                try {
                    response.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                        @Override
                        public OutputStream getOutputStream(int contentLength) throws IOException {
                            OutputStream outputStream = writer.writeResponseStatusAndHeaders(contentLength, response);
                            return isHead ? null : outputStream;
                        }
                    });
                    if ((writer.enableResponseBuffering() || isHead) && !response.isChunked()) {
                        response.enableBuffering(this.configuration);
                    }
                    try {
                        response.setEntityStream(this.request.getWorkers().writeTo(entity, entity.getClass(), response.getEntityType(), response.getEntityAnnotations(), response.getMediaType(), response.getHeaders(), this.request.getPropertiesDelegate(), response.getEntityStream(), true));
                    }
                    catch (IOException ioe) {
                        this.connectionCallbackRunner.onDisconnect((AsyncResponse)this.asyncContext.get());
                        throw ioe;
                    }
                }
                catch (Throwable ex) {
                    if (response.isCommitted()) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY(), ex);
                        break block32;
                    }
                    skipFinally = true;
                    throw new MappableException(ex);
                }
                finally {
                    if (!skipFinally) {
                        if (response.isChunked()) {
                            try {
                                response.commitStream();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_COMMITTING_OUTPUT_STREAM(), e);
                            }
                            try {
                                ((ChunkedOutput)entity).setContext(this.request, response, this.connectionCallbackRunner, this.asyncContext);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex);
                            }
                            if (writer.suspend(0L, TimeUnit.SECONDS, null)) {
                                // empty if block
                            }
                        } else {
                            try {
                                response.close();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_CLOSING_COMMIT_OUTPUT_STREAM(), e);
                            }
                        }
                    }
                }
            }
            return response;
        }

        private void release(ContainerResponse responseContext) {
            try {
                ((CloseableService)this.closeableService.get()).close();
                if (responseContext != null && !responseContext.isChunked()) {
                    responseContext.close();
                }
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Attempt to release single request processing resources has failed.", throwable);
            }
        }
    }

    private static class AsyncResponderHolder
    implements Value<AsyncContext> {
        private final Responder responder;
        private final ServiceLocator locator;
        private final RequestScope requestScope;
        private final RequestScope.Instance scopeInstance;
        private final ExecutorsFactory<ContainerRequest> asyncExecutorsFactory;
        private volatile AsyncResponder asyncResponder;

        private AsyncResponderHolder(Responder responder, ServiceLocator locator, RequestScope requestScope, RequestScope.Instance scopeInstance, ExecutorsFactory<ContainerRequest> asyncExecutorsFactory) {
            this.responder = responder;
            this.locator = locator;
            this.requestScope = requestScope;
            this.scopeInstance = scopeInstance;
            this.asyncExecutorsFactory = asyncExecutorsFactory;
        }

        @Override
        public AsyncResponder get() {
            AsyncResponder ar;
            this.asyncResponder = ar = new AsyncResponder(this.responder, this.locator, this.requestScope, this.scopeInstance, this.asyncExecutorsFactory);
            return ar;
        }

        public boolean isAsync() {
            AsyncResponder ar = this.asyncResponder;
            return ar != null && !ar.isRunning();
        }

        public void release() {
            if (this.asyncResponder == null) {
                this.scopeInstance.release();
            }
        }
    }

    public static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        private RequestScope requestScope;
        @Inject
        private ExceptionMappers exceptionMappers;
        @Inject
        private Provider<CloseableService> closeableServiceProvider;
        @Inject
        private Provider<Ref<Value<AsyncContext>>> asyncContextRefProvider;
        @Inject
        private Provider<AsyncContext> asyncContextProvider;
        @Inject
        private ExecutorsFactory<ContainerRequest> asyncExecutorsFactory;
        @Inject
        private Configuration configuration;

        public ServerRuntime build(Stage<ContainerRequest> requestProcessingRoot) {
            return new ServerRuntime(requestProcessingRoot, this.locator, this.requestScope, this.exceptionMappers, this.closeableServiceProvider, this.asyncContextRefProvider, this.asyncContextProvider, this.asyncExecutorsFactory, this.configuration);
        }
    }
}

