/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.MessageBodyProcessingException;

@Priority(value=10)
@Singleton
public class ExceptionWrapperInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            return context.proceed();
        }
        catch (WebApplicationException wae) {
            throw new MessageBodyProcessingException(LocalizationMessages.ERROR_PROCESSING_MESSAGEBODY(), wae);
        }
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (WebApplicationException wae) {
            throw new MessageBodyProcessingException(LocalizationMessages.ERROR_PROCESSING_MESSAGEBODY(), wae);
        }
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(ExceptionWrapperInterceptor.class).to(ReaderInterceptor.class).to(WriterInterceptor.class).in(Singleton.class);
        }
    }
}

