
package org.glassfish.jersey.client.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.client.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCHUNKED_INPUT_MEDIA_TYPE_NULL() {
        return messageFactory.getMessage("chunked.input.media.type.null");
    }

    /**
     * Specified chunk media type must not be null.
     * 
     */
    public static String CHUNKED_INPUT_MEDIA_TYPE_NULL() {
        return localizer.localize(localizableCHUNKED_INPUT_MEDIA_TYPE_NULL());
    }

    public static Localizable localizableRESPONSE_TYPE_IS_NULL() {
        return messageFactory.getMessage("response.type.is.null");
    }

    /**
     * Requested response type is null.
     * 
     */
    public static String RESPONSE_TYPE_IS_NULL() {
        return localizer.localize(localizableRESPONSE_TYPE_IS_NULL());
    }

    public static Localizable localizableCHUNKED_INPUT_CLOSED() {
        return messageFactory.getMessage("chunked.input.closed");
    }

    /**
     * Chunked input has been closed already.
     * 
     */
    public static String CHUNKED_INPUT_CLOSED() {
        return localizer.localize(localizableCHUNKED_INPUT_CLOSED());
    }

    public static Localizable localizableHTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY() {
        return messageFactory.getMessage("httpurlconnection.replaces.get.with.entity");
    }

    /**
     * Detected non-empty entity on a HTTP GET request. The underlying HTTP transport connector may decide to change the request method to POST.
     * 
     */
    public static String HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY() {
        return localizer.localize(localizableHTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
    }

    public static Localizable localizableUNEXPECTED_ERROR_RESPONSE_PROCESSING() {
        return messageFactory.getMessage("unexpected.error.response.processing");
    }

    /**
     * Unexpected error during response processing.
     * 
     */
    public static String UNEXPECTED_ERROR_RESPONSE_PROCESSING() {
        return localizer.localize(localizableUNEXPECTED_ERROR_RESPONSE_PROCESSING());
    }

    public static Localizable localizableRESPONSE_TO_EXCEPTION_CONVERSION_FAILED() {
        return messageFactory.getMessage("response.to.exception.conversion.failed");
    }

    /**
     * Failed to convert a response into an exception.
     * 
     */
    public static String RESPONSE_TO_EXCEPTION_CONVERSION_FAILED() {
        return localizer.localize(localizableRESPONSE_TO_EXCEPTION_CONVERSION_FAILED());
    }

    public static Localizable localizableUSE_ENCODING_IGNORED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("use.encoding.ignored", arg0, arg1, arg2);
    }

    /**
     * Value {1} of {0} client property will be ignored as it is not a valid supported encoding. Valid supported encodings are: {2}
     * 
     */
    public static String USE_ENCODING_IGNORED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableUSE_ENCODING_IGNORED(arg0, arg1, arg2));
    }

    public static Localizable localizableCHUNKED_INPUT_STREAM_CLOSING_ERROR() {
        return messageFactory.getMessage("chunked.input.stream.closing.error");
    }

    /**
     * Error closing chunked input's underlying response input stream.
     * 
     */
    public static String CHUNKED_INPUT_STREAM_CLOSING_ERROR() {
        return localizer.localize(localizableCHUNKED_INPUT_STREAM_CLOSING_ERROR());
    }

    public static Localizable localizableERROR_HTTP_METHOD_ENTITY_NULL(Object arg0) {
        return messageFactory.getMessage("error.http.method.entity.null", arg0);
    }

    /**
     * Entity must not be null for http method {0}.
     * 
     */
    public static String ERROR_HTTP_METHOD_ENTITY_NULL(Object arg0) {
        return localizer.localize(localizableERROR_HTTP_METHOD_ENTITY_NULL(arg0));
    }

    public static Localizable localizableERROR_HTTP_METHOD_ENTITY_NOT_NULL(Object arg0) {
        return messageFactory.getMessage("error.http.method.entity.not.null", arg0);
    }

    /**
     * Entity must be null for http method {0}.
     * 
     */
    public static String ERROR_HTTP_METHOD_ENTITY_NOT_NULL(Object arg0) {
        return localizer.localize(localizableERROR_HTTP_METHOD_ENTITY_NOT_NULL(arg0));
    }

}
