
package org.glassfish.jersey.servlet.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.servlet.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableFORM_PARAM_CONSUMED(Object arg0) {
        return messageFactory.getMessage("form.param.consumed", arg0);
    }

    /**
     * A servlet request to the URI {0} contains form parameters in the request body but the request body has been consumed by the servlet or a servlet filter accessing the request parameters. Only resource methods using @FormParam will work as expected. Resource methods consuming the request body by other means will not work as expected.
     * 
     */
    public static String FORM_PARAM_CONSUMED(Object arg0) {
        return localizer.localize(localizableFORM_PARAM_CONSUMED(arg0));
    }

    public static Localizable localizableNO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(Object arg0) {
        return messageFactory.getMessage("no.request.dispatcher.for.resolved.path", arg0);
    }

    /**
     * No request dispatcher for: {0}
     * 
     */
    public static String NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(Object arg0) {
        return localizer.localize(localizableNO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(arg0));
    }

    public static Localizable localizableSERVLET_PATH_MISMATCH(Object arg0, Object arg1) {
        return messageFactory.getMessage("servlet.path.mismatch", arg0, arg1);
    }

    /**
     * The servlet path {0} does not start with the filter context path {1}.
     * 
     */
    public static String SERVLET_PATH_MISMATCH(Object arg0, Object arg1) {
        return localizer.localize(localizableSERVLET_PATH_MISMATCH(arg0, arg1));
    }

    public static Localizable localizableNO_THREAD_LOCAL_VALUE(Object arg0) {
        return messageFactory.getMessage("no.thread.local.value", arg0);
    }

    /**
     * No thread local value in scope for proxy of {0}.
     * 
     */
    public static String NO_THREAD_LOCAL_VALUE(Object arg0) {
        return localizer.localize(localizableNO_THREAD_LOCAL_VALUE(arg0));
    }

    public static Localizable localizableINIT_PARAM_REGEX_SYNTAX_INVALID(Object arg0, Object arg1) {
        return messageFactory.getMessage("init.param.regex.syntax.invalid", arg0, arg1);
    }

    /**
     * The syntax is invalid for the regular expression "{0}" associated with the initialization parameter "{1}".
     * 
     */
    public static String INIT_PARAM_REGEX_SYNTAX_INVALID(Object arg0, Object arg1) {
        return localizer.localize(localizableINIT_PARAM_REGEX_SYNTAX_INVALID(arg0, arg1));
    }

    public static Localizable localizableRESOURCE_CONFIG_UNABLE_TO_LOAD(Object arg0) {
        return messageFactory.getMessage("resource.config.unable.to.load", arg0);
    }

    /**
     * Resource configuration class {0} could not be loaded.
     * 
     */
    public static String RESOURCE_CONFIG_UNABLE_TO_LOAD(Object arg0) {
        return localizer.localize(localizableRESOURCE_CONFIG_UNABLE_TO_LOAD(arg0));
    }

    public static Localizable localizableRESOURCE_PATH_NOT_IN_CORRECT_FORM(Object arg0) {
        return messageFactory.getMessage("resource.path.not.in.correct.form", arg0);
    }

    /**
     * Resource path "{0}" is not in correct form.
     * 
     */
    public static String RESOURCE_PATH_NOT_IN_CORRECT_FORM(Object arg0) {
        return localizer.localize(localizableRESOURCE_PATH_NOT_IN_CORRECT_FORM(arg0));
    }

    public static Localizable localizablePERSISTENCE_UNIT_NOT_CONFIGURED(Object arg0) {
        return messageFactory.getMessage("persistence.unit.not.configured", arg0);
    }

    /**
     * Persistence unit "{0}" is not configured as a servlet parameter in web.xml.
     * 
     */
    public static String PERSISTENCE_UNIT_NOT_CONFIGURED(Object arg0) {
        return localizer.localize(localizablePERSISTENCE_UNIT_NOT_CONFIGURED(arg0));
    }

    public static Localizable localizableRESOURCE_CONFIG_PARENT_CLASS_INVALID(Object arg0, Object arg1) {
        return messageFactory.getMessage("resource.config.parent.class.invalid", arg0, arg1);
    }

    /**
     * Resource configuration class {0} is not a subclass of {1}.
     * 
     */
    public static String RESOURCE_CONFIG_PARENT_CLASS_INVALID(Object arg0, Object arg1) {
        return localizer.localize(localizableRESOURCE_CONFIG_PARENT_CLASS_INVALID(arg0, arg1));
    }

}
