/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.ExtendedConfig;
import org.glassfish.jersey.client.ClientBinder;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.client.HttpUrlConnector;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.model.internal.CommonConfig;
import org.glassfish.jersey.model.internal.ComponentBag;

public class ClientConfig
implements Configurable<ClientConfig>,
Configuration {
    private State state;

    public ClientConfig() {
        this.state = new State(null);
    }

    public ClientConfig(Class<?> ... providerClasses) {
        this();
        for (Class<?> providerClass : providerClasses) {
            this.state.register((Class)providerClass);
        }
    }

    public ClientConfig(Object ... providers) {
        this();
        for (Object provider : providers) {
            this.state.register(provider);
        }
    }

    ClientConfig(JerseyClient parent) {
        this.state = new State(parent);
        this.state.setConnector(new HttpUrlConnector());
    }

    ClientConfig(JerseyClient parent, Configuration that) {
        if (that instanceof ClientConfig) {
            this.state = ((ClientConfig)that).state.copy(parent);
            if (this.state.getConnector() == null) {
                this.state.setConnector(new HttpUrlConnector());
            }
        } else {
            this.state = new State(parent);
            this.state.setConnector(new HttpUrlConnector());
            this.state.replaceWith(that);
        }
    }

    private ClientConfig(State state) {
        this.state = state;
    }

    ClientConfig snapshot() {
        this.state.markAsShared();
        return new ClientConfig(this.state);
    }

    @Override
    public ClientConfig replaceWith(Configuration config) {
        if (config instanceof ClientConfig) {
            this.state = ((ClientConfig)config).state.copy();
            if (this.state.getConnector() == null) {
                this.state.setConnector(new HttpUrlConnector());
            }
        } else {
            this.state.replaceWith(config);
        }
        return this;
    }

    @Override
    public ClientConfig register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    @Override
    public ClientConfig register(Object provider) {
        this.state = this.state.register(provider);
        return this;
    }

    @Override
    public ClientConfig register(Class<?> providerClass, int bindingPriority) {
        this.state = this.state.register((Class)providerClass, bindingPriority);
        return this;
    }

    @Override
    public ClientConfig register(Class<?> providerClass, Class<?> ... contracts) {
        this.state = this.state.register((Class)providerClass, (Class[])contracts);
        return this;
    }

    @Override
    public ClientConfig register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        this.state = this.state.register((Class)providerClass, (Map)contracts);
        return this;
    }

    @Override
    public ClientConfig register(Object provider, int bindingPriority) {
        this.state = this.state.register(provider, bindingPriority);
        return this;
    }

    @Override
    public ClientConfig register(Object provider, Class<?> ... contracts) {
        this.state = this.state.register(provider, (Class[])contracts);
        return this;
    }

    @Override
    public ClientConfig register(Object provider, Map<Class<?>, Integer> contracts) {
        this.state = this.state.register(provider, (Map)contracts);
        return this;
    }

    @Override
    public ClientConfig property(String name, Object value) {
        this.state = this.state.property(name, value);
        return this;
    }

    @Override
    public ClientConfig getConfiguration() {
        return this;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.state.getRuntimeType();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    @Override
    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.state.getPropertyNames();
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return this.state.isEnabled(feature);
    }

    @Override
    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.state.isEnabled(featureClass);
    }

    @Override
    public boolean isRegistered(Object component) {
        return this.state.isRegistered(component);
    }

    @Override
    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        return this.state.getContracts(componentClass);
    }

    @Override
    public boolean isRegistered(Class<?> componentClass) {
        return this.state.isRegistered(componentClass);
    }

    @Override
    public Set<Class<?>> getClasses() {
        return this.state.getClasses();
    }

    @Override
    public Set<Object> getInstances() {
        return this.state.getInstances();
    }

    public ClientConfig connector(Connector connector) {
        this.state = this.state.setConnector(connector);
        return this;
    }

    public Connector getConnector() {
        return this.state.getConnector();
    }

    ClientRuntime getRuntime() {
        return (ClientRuntime)this.state.runtime.get();
    }

    public JerseyClient getClient() {
        return this.state.getClient();
    }

    ClientConfig preInitialize() {
        this.state = this.state.preInitialize();
        return this;
    }

    void checkClient() throws IllegalStateException {
        if (this.getClient() == null) {
            throw new IllegalStateException("Client configuration does not contain a parent client instance.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements Configurable<State>,
    Configuration {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private volatile StateChangeStrategy strategy;
        private final CommonConfig commonConfig;
        private final JerseyClient client;
        private Connector connector;
        private final Value<ClientRuntime> runtime = Values.lazy(new Value<ClientRuntime>(){

            @Override
            public ClientRuntime get() {
                return State.this.initRuntime();
            }
        });

        State(JerseyClient client) {
            this.commonConfig = new CommonConfig(RuntimeType.CLIENT, ComponentBag.EXCLUDE_EMPTY);
            this.client = client;
            this.strategy = IDENTITY;
            this.connector = null;
        }

        private State(JerseyClient client, State original) {
            this.client = client;
            this.strategy = IDENTITY;
            this.commonConfig = new CommonConfig(original.commonConfig);
            this.connector = original.connector;
        }

        State copy() {
            return new State(this.client, this);
        }

        State copy(JerseyClient client) {
            return new State(client, this);
        }

        void markAsShared() {
            this.strategy = COPY_ON_CHANGE;
        }

        State preInitialize() {
            State state = this.strategy.onChange(this);
            state.strategy = COPY_ON_CHANGE;
            state.runtime.get().preInitialize();
            return state;
        }

        public State setProperties(Map<String, ?> properties) {
            State state = this.strategy.onChange(this);
            state.commonConfig.setProperties(properties);
            return state;
        }

        @Override
        public State property(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.commonConfig.property(name, value);
            return state;
        }

        @Override
        public State replaceWith(Configuration config) {
            State state = this.strategy.onChange(this);
            state.commonConfig.replaceWith(config);
            return state;
        }

        @Override
        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register((Class)providerClass);
            return state;
        }

        @Override
        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider);
            return state;
        }

        @Override
        public State register(Class<?> providerClass, int bindingPriority) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register((Class)providerClass, bindingPriority);
            return state;
        }

        @Override
        public State register(Class<?> providerClass, Class<?> ... contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register((Class)providerClass, (Class[])contracts);
            return state;
        }

        @Override
        public State register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register((Class)providerClass, (Map)contracts);
            return state;
        }

        @Override
        public State register(Object provider, int bindingPriority) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider, bindingPriority);
            return state;
        }

        @Override
        public State register(Object provider, Class<?> ... contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider, (Class[])contracts);
            return state;
        }

        @Override
        public State register(Object provider, Map<Class<?>, Integer> contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider, (Map)contracts);
            return state;
        }

        public State setConnector(Connector connector) {
            State state = this.strategy.onChange(this);
            state.connector = connector;
            return state;
        }

        Connector getConnector() {
            return this.connector;
        }

        JerseyClient getClient() {
            return this.client;
        }

        @Override
        public State getConfiguration() {
            return this;
        }

        @Override
        public RuntimeType getRuntimeType() {
            return this.commonConfig.getConfiguration().getRuntimeType();
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.commonConfig.getConfiguration().getProperties();
        }

        @Override
        public Object getProperty(String name) {
            return this.commonConfig.getConfiguration().getProperty(name);
        }

        @Override
        public Collection<String> getPropertyNames() {
            return this.commonConfig.getConfiguration().getPropertyNames();
        }

        @Override
        public boolean isEnabled(Feature feature) {
            return this.commonConfig.getConfiguration().isEnabled(feature);
        }

        @Override
        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return this.commonConfig.getConfiguration().isEnabled(featureClass);
        }

        @Override
        public boolean isRegistered(Object component) {
            return this.commonConfig.getConfiguration().isRegistered(component);
        }

        @Override
        public boolean isRegistered(Class<?> componentClass) {
            return this.commonConfig.getConfiguration().isRegistered(componentClass);
        }

        @Override
        public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
            return this.commonConfig.getConfiguration().getContracts(componentClass);
        }

        @Override
        public Set<Class<?>> getClasses() {
            return this.commonConfig.getConfiguration().getClasses();
        }

        @Override
        public Set<Object> getInstances() {
            return this.commonConfig.getConfiguration().getInstances();
        }

        private ClientRuntime initRuntime() {
            this.markAsShared();
            final ServiceLocator locator = Injections.createLocator(new Binder[]{new ClientBinder()});
            locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
            CommonConfig runtimeConfig = new CommonConfig(this.commonConfig);
            if (!PropertiesHelper.isFeatureDisabledByProperty(runtimeConfig, "jersey.config.disableAutoDiscovery")) {
                runtimeConfig.configureAutoDiscoverableProviders(locator);
            }
            runtimeConfig.configureMetaProviders(locator);
            final ExtendedConfig configuration = runtimeConfig.getConfiguration();
            AbstractBinder configBinder = new AbstractBinder(){

                protected void configure() {
                    this.bind(configuration).to(Configuration.class);
                }
            };
            DynamicConfiguration dc = Injections.getConfiguration(locator);
            configBinder.bind(dc);
            dc.commit();
            ProviderBinder.bindProviders(runtimeConfig.getComponentBag(), RuntimeType.CLIENT, null, locator);
            final ClientRuntime crt = new ClientRuntime(configuration, this.connector, locator);
            this.client.addListener(new JerseyClient.LifecycleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClose() {
                    try {
                        crt.close();
                    }
                    finally {
                        ServiceLocatorFactory.getInstance().destroy(locator.getName());
                    }
                }
            });
            return crt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.client != null ? !this.client.equals(state.client) : state.client != null) {
                return false;
            }
            if (!this.commonConfig.equals(state.commonConfig)) {
                return false;
            }
            return !(this.connector != null ? !this.connector.equals(state.connector) : state.connector != null);
        }

        public int hashCode() {
            int result = this.commonConfig.hashCode();
            result = 31 * result + (this.client != null ? this.client.hashCode() : 0);
            result = 31 * result + (this.connector != null ? this.connector.hashCode() : 0);
            return result;
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

