/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.inject.Provider;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.AsyncContext;

public class ChunkedOutput<T>
extends GenericType<T>
implements Closeable {
    private final BlockingDeque<T> queue = new LinkedBlockingDeque<T>();
    private volatile boolean closed = false;
    private boolean flushing = false;
    private volatile ContainerRequest requestContext;
    private volatile ContainerResponse responseContext;
    private volatile ServerRuntime.ConnectionCallbackRunner connectionCallbackRunner;
    private volatile Provider<AsyncContext> asyncContext;

    protected ChunkedOutput() {
    }

    public ChunkedOutput(Type chunkType) {
        super(chunkType);
    }

    public void write(T chunk) throws IOException {
        if (this.closed) {
            throw new IOException(LocalizationMessages.CHUNKED_OUTPUT_CLOSED());
        }
        if (chunk != null) {
            this.queue.add(chunk);
        }
        this.flushQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void flushQueue() throws IOException {
        block30: {
            T t;
            boolean shouldClose;
            if (this.requestContext == null || this.responseContext == null) {
                return;
            }
            Exception ex = null;
            ChunkedOutput chunkedOutput = this;
            synchronized (chunkedOutput) {
                if (this.flushing) {
                    return;
                }
                shouldClose = this.closed;
                t = this.queue.poll();
                if (t != null || shouldClose) {
                    this.flushing = true;
                }
            }
            while (t != null) {
                try {
                    this.responseContext.setEntityStream(this.requestContext.getWorkers().writeTo(t, t.getClass(), this.getType(), this.responseContext.getEntityAnnotations(), this.responseContext.getMediaType(), this.responseContext.getHeaders(), this.requestContext.getPropertiesDelegate(), this.responseContext.getEntityStream(), null, true));
                }
                catch (IOException ioe) {
                    this.connectionCallbackRunner.onDisconnect((AsyncResponse)this.asyncContext.get());
                    throw ioe;
                }
                t = this.queue.poll();
                if (t != null) continue;
                ChunkedOutput ioe = this;
                synchronized (ioe) {
                    shouldClose = this.closed;
                    t = this.queue.poll();
                    if (t == null) {
                        this.responseContext.commitStream();
                        this.flushing = shouldClose;
                        break;
                    }
                }
            }
            if (!shouldClose) break block30;
            try {
                this.responseContext.close();
            }
            catch (Exception e) {
                Exception exception = ex = ex == null ? e : ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            break block30;
            catch (Exception e) {
                try {
                    this.closed = true;
                    shouldClose = true;
                    ex = e;
                    if (!shouldClose) break block30;
                }
                catch (Throwable throwable) {
                    if (shouldClose) {
                        try {
                            this.responseContext.close();
                        }
                        catch (Exception e2) {
                            Exception exception = ex = ex == null ? e2 : ex;
                        }
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                    }
                    throw throwable;
                }
                try {
                    this.responseContext.close();
                }
                catch (Exception e3) {
                    Exception exception = ex = ex == null ? e3 : ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushQueue();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return this.queue.hashCode();
    }

    @Override
    public String toString() {
        return "ChunkedOutput<" + this.getType() + ">";
    }

    void setContext(ContainerRequest requestContext, ContainerResponse responseContext, ServerRuntime.ConnectionCallbackRunner connectionCallbackRunner, Provider<AsyncContext> asyncContext) throws IOException {
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.connectionCallbackRunner = connectionCallbackRunner;
        this.asyncContext = asyncContext;
        this.flushQueue();
    }
}

