/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.spi.RequestExecutorsProvider;
import org.glassfish.jersey.spi.ResponseExecutorsProvider;

class ServerExecutorsFactory
extends ExecutorsFactory<ContainerRequest> {
    private final ExecutorService requestingExecutor = this.getInitialRequestingExecutor(new RequestExecutorsProvider(){

        @Override
        public ExecutorService getRequestingExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("jersey-server-managed-async-executor-%d").build());
        }
    });
    private final ExecutorService respondingExecutor = this.getInitialRespondingExecutor(new ResponseExecutorsProvider(){

        @Override
        public ExecutorService getRespondingExecutor() {
            return MoreExecutors.sameThreadExecutor();
        }
    });

    @Inject
    public ServerExecutorsFactory(ServiceLocator locator) {
        super(locator);
    }

    @Override
    public ExecutorService getRequestingExecutor(ContainerRequest request) {
        return this.requestingExecutor;
    }

    @Override
    public ExecutorService getRespondingExecutor(ContainerRequest request) {
        return this.respondingExecutor;
    }
}

