/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.server.model.internal.ModelHelper;
import org.glassfish.jersey.server.model.internal.ModelProcessorUtil;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.internal.ImplicitViewable;

class TemplateModelProcessor
implements ModelProcessor {
    private static final String IMPLICIT_VIEW_PATH_PARAMETER = "implicit-view-path-parameter";
    private static final String IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE = "{implicit-view-path-parameter}";
    private final ResourceContext resourceContext;
    private final Provider<ExtendedUriInfo> extendedUriInfoProvider;

    @Inject
    TemplateModelProcessor(ResourceContext resourceContext, Provider<ExtendedUriInfo> extendedUriInfoProvider) {
        this.resourceContext = resourceContext;
        this.extendedUriInfoProvider = extendedUriInfoProvider;
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return this.processModel(resourceModel, false);
    }

    @Override
    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return this.processModel(subResourceModel, true);
    }

    private ResourceModel processModel(ResourceModel resourceModel, boolean subResourceModel) {
        ResourceModel.Builder newModelBuilder = new ResourceModel.Builder(resourceModel, subResourceModel);
        for (RuntimeResource resource : resourceModel.getRuntimeResourceModel().getRuntimeResources()) {
            ModelProcessorUtil.enhanceResource(resource, newModelBuilder, this.getEnhancingMethods(resource));
        }
        return newModelBuilder.build();
    }

    private List<ModelProcessorUtil.Method> getEnhancingMethods(RuntimeResource runtimeResource) {
        final ArrayList newMethods = Lists.newArrayList();
        for (final Resource resource : runtimeResource.getResources()) {
            for (Class<?> handlerClass : resource.getHandlerClasses()) {
                this.createEnhancingMethods(handlerClass, null, newMethods);
            }
            if (resource.getHandlerClasses().isEmpty() && resource.getHandlerInstances().isEmpty()) {
                for (String resourceName : resource.getNames()) {
                    Class resourceClass = ReflectionHelper.classForName(resourceName);
                    if (resourceClass == null) continue;
                    this.createEnhancingMethods(resourceClass, null, newMethods);
                }
            }
            Errors.process(new Producer<Void>(){

                @Override
                public Void call() {
                    for (Object handlerInstance : resource.getHandlerInstances()) {
                        Class<?> handlerInstanceClass = handlerInstance.getClass();
                        if (!resource.getHandlerClasses().contains(handlerInstanceClass)) {
                            TemplateModelProcessor.this.createEnhancingMethods(handlerInstanceClass, handlerInstance, newMethods);
                            continue;
                        }
                        Errors.warning(resource, LocalizationMessages.TEMPLATE_HANDLER_ALREADY_ENHANCED(handlerInstanceClass));
                    }
                    return null;
                }
            });
        }
        return newMethods;
    }

    private void createEnhancingMethods(Class<?> resourceClass, Object resourceInstance, List<ModelProcessorUtil.Method> newMethods) {
        Template template = resourceClass.getAnnotation(Template.class);
        if (template != null) {
            Class<?> annotatedResourceClass = ModelHelper.getAnnotatedResourceClass(resourceClass);
            List<MediaType> produces = MediaTypes.createQualitySourceMediaTypes(annotatedResourceClass.getAnnotation(Produces.class));
            List<MediaType> consumes = MediaTypes.createFrom(annotatedResourceClass.getAnnotation(Consumes.class));
            TemplateInflector inflector = new TemplateInflector(template.name(), template.resolvingClass(), resourceClass, resourceInstance);
            newMethods.add(new ModelProcessorUtil.Method("GET", consumes, produces, (Inflector<ContainerRequestContext, Response>)inflector));
            newMethods.add(new ModelProcessorUtil.Method(IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE, "GET", consumes, produces, (Inflector<ContainerRequestContext, Response>)inflector));
        }
    }

    private class TemplateInflector
    implements Inflector<ContainerRequestContext, Response> {
        private final String templateName;
        private final Class<?> resolvingClass;
        private final Class<?> resourceClass;
        private final Object resourceInstance;

        private TemplateInflector(String templateName, Class<?> resolvingClass, Class<?> resourceClass, Object resourceInstance) {
            this.templateName = templateName;
            this.resolvingClass = resolvingClass;
            this.resourceClass = resourceClass;
            this.resourceInstance = resourceInstance;
        }

        @Override
        public Response apply(ContainerRequestContext requestContext) {
            ExtendedUriInfo extendedUriInfo = (ExtendedUriInfo)TemplateModelProcessor.this.extendedUriInfoProvider.get();
            List<String> templateNames = this.getTemplateNames(requestContext);
            Object model = this.getModel(extendedUriInfo);
            Class<?> resolvingClass = Object.class.equals(this.resolvingClass) || this.resolvingClass == null ? this.resourceClass : this.resolvingClass;
            return Response.ok().entity(new ImplicitViewable(templateNames, model, resolvingClass)).build();
        }

        private Object getModel(ExtendedUriInfo extendedUriInfo) {
            List<Object> matchedResources = extendedUriInfo.getMatchedResources();
            if (this.resourceInstance != null) {
                return this.resourceInstance;
            }
            if (matchedResources.size() > 1) {
                return matchedResources.get(1);
            }
            return TemplateModelProcessor.this.resourceContext.getResource(this.resourceClass);
        }

        private List<String> getTemplateNames(ContainerRequestContext requestContext) {
            RuntimeResource lastMatchedRuntimeResource;
            Resource lastMatchedResource;
            String path;
            ExtendedUriInfo uriInfo;
            List<RuntimeResource> matchedRuntimeResources;
            ArrayList templateNames = Lists.newArrayList();
            String pathTemplate = requestContext.getUriInfo().getPathParameters().getFirst(TemplateModelProcessor.IMPLICIT_VIEW_PATH_PARAMETER);
            if (pathTemplate != null) {
                templateNames.add(pathTemplate);
            }
            if (this.templateName != null && !"".equals(this.templateName)) {
                templateNames.add(this.templateName);
            }
            if ((matchedRuntimeResources = (uriInfo = (ExtendedUriInfo)TemplateModelProcessor.this.extendedUriInfoProvider.get()).getMatchedRuntimeResources()).size() > 1 && (path = (lastMatchedResource = (lastMatchedRuntimeResource = matchedRuntimeResources.get(0)).getResources().get(0)).getPath()) != null && !TemplateModelProcessor.IMPLICIT_VIEW_PATH_PARAMETER_TEMPLATE.equals(path)) {
                path = path.charAt(0) == '/' ? path.substring(1, path.length()) : path;
                templateNames.add(path);
            }
            if (templateNames.isEmpty()) {
                templateNames.add("index");
            }
            return templateNames;
        }
    }
}

