/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.mvc.internal;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.mvc.Viewable;

public final class RequestDispatcherWrapper
implements RequestDispatcher {
    private static final String BASE_PATH_ATTRIBUTE_NAME = "_basePath";
    private static final String HTTP_CONTEXT_ATTRIBUTE_NAME = "httpContext";
    private static final String MODEL_ATTRIBUTE_NAME = "it";
    private static final String RESOLVING_CLASS_ATTRIBUTE_NAME = "resolvingClass";
    private static final String REQUEST_ATTRIBUTE_NAME = "_request";
    private static final String RESPONSE_ATTRIBUTE_NAME = "_response";
    private final RequestDispatcher dispatcher;
    private final String basePath;
    private final HttpContext httpContext;
    private final Viewable viewable;

    public RequestDispatcherWrapper(RequestDispatcher dispatcher, String basePath, HttpContext httpContext, Viewable viewable) {
        this.dispatcher = dispatcher;
        this.basePath = basePath;
        this.httpContext = httpContext;
        this.viewable = viewable;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Object oldIt = request.getAttribute(MODEL_ATTRIBUTE_NAME);
        Object oldResolvingClass = request.getAttribute(RESOLVING_CLASS_ATTRIBUTE_NAME);
        request.setAttribute(RESOLVING_CLASS_ATTRIBUTE_NAME, this.viewable.getResolvingClass());
        request.setAttribute(MODEL_ATTRIBUTE_NAME, this.viewable.getModel());
        request.setAttribute(HTTP_CONTEXT_ATTRIBUTE_NAME, (Object)this.httpContext);
        request.setAttribute(BASE_PATH_ATTRIBUTE_NAME, (Object)this.basePath);
        request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)request);
        request.setAttribute(RESPONSE_ATTRIBUTE_NAME, (Object)response);
        this.dispatcher.forward(request, response);
        request.setAttribute(RESOLVING_CLASS_ATTRIBUTE_NAME, oldResolvingClass);
        request.setAttribute(MODEL_ATTRIBUTE_NAME, oldIt);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }
}

