/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.CompletableReader;
import org.glassfish.jersey.message.internal.EntityInputStream;
import org.glassfish.jersey.message.internal.InterceptorExecutor;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;

public final class ReaderInterceptorExecutor
extends InterceptorExecutor
implements ReaderInterceptorContext {
    private InputStream inputStream;
    private final MultivaluedMap<String, String> headers;
    private final Iterator<ReaderInterceptor> interceptors;
    private final MessageBodyWorkers workers;
    private final boolean translateNce;

    public ReaderInterceptorExecutor(Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, PropertiesDelegate propertiesDelegate, InputStream inputStream, MessageBodyWorkers workers, Iterable<ReaderInterceptor> readerInterceptors, boolean translateNce) {
        super(rawType, type, annotations, mediaType, propertiesDelegate);
        this.headers = headers;
        this.inputStream = inputStream;
        this.workers = workers;
        this.translateNce = translateNce;
        ArrayList effectiveInterceptors = Lists.newArrayList(readerInterceptors);
        effectiveInterceptors.add(new TerminalReaderInterceptor());
        this.interceptors = effectiveInterceptors.iterator();
    }

    @Override
    public Object proceed() throws IOException {
        if (!this.interceptors.hasNext()) {
            throw new ProcessingException(LocalizationMessages.ERROR_INTERCEPTOR_READER_PROCEED());
        }
        return this.interceptors.next().aroundReadFrom(this);
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    private class TerminalReaderInterceptor
    implements ReaderInterceptor {
        private TerminalReaderInterceptor() {
        }

        @Override
        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            Object entity;
            MessageBodyReader<?> bodyReader = ReaderInterceptorExecutor.this.workers.getMessageBodyReader(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType());
            EntityInputStream input = new EntityInputStream(context.getInputStream());
            if (bodyReader == null) {
                if (input.isEmpty() && !context.getHeaders().containsKey("Content-Type")) {
                    return null;
                }
                throw new MessageBodyProviderNotFoundException(LocalizationMessages.ERROR_NOTFOUND_MESSAGEBODYREADER(context.getMediaType(), context.getType(), context.getGenericType()));
            }
            if (ReaderInterceptorExecutor.this.translateNce) {
                try {
                    entity = bodyReader.readFrom(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType(), context.getHeaders(), input);
                }
                catch (NoContentException ex) {
                    throw new BadRequestException(ex);
                }
            } else {
                entity = bodyReader.readFrom(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType(), context.getHeaders(), input);
            }
            if (bodyReader instanceof CompletableReader) {
                entity = ((CompletableReader)((Object)bodyReader)).complete(entity);
            }
            return entity;
        }
    }
}

