/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.uri.PathTemplate;

public class RuntimeResourceModel {
    private final List<RuntimeResource> runtimeResources;

    public RuntimeResourceModel(List<Resource> resources) {
        List wrappers = Lists.transform(resources, this.getWrappingFunction(null));
        this.runtimeResources = Lists.newArrayList();
        for (RuntimeResource.Builder builder : this.getRuntimeResources(wrappers)) {
            this.runtimeResources.add(builder.build(null));
        }
        Collections.sort(this.runtimeResources, RuntimeResource.COMPARATOR);
    }

    private List<RuntimeResource.Builder> getRuntimeResources(List<RuntimeResource.ResourceWrapper> resources) {
        HashMap regexMap = Maps.newHashMap();
        for (RuntimeResource.ResourceWrapper wrapper : resources) {
            List listFromMap;
            String path = wrapper.getResource().getPath();
            String regex = null;
            if (path != null) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                regex = new PathTemplate(path).getPattern().getRegex();
            }
            if ((listFromMap = (List)regexMap.get(regex)) == null) {
                listFromMap = Lists.newArrayList();
                regexMap.put(regex, listFromMap);
            }
            listFromMap.add(wrapper);
        }
        ArrayList runtimeResources = Lists.newArrayList();
        for (Map.Entry entry : regexMap.entrySet()) {
            List resourcesWithSameRegex = (List)entry.getValue();
            ArrayList childResources = Lists.newArrayList();
            for (RuntimeResource.ResourceWrapper res : resourcesWithSameRegex) {
                childResources.addAll(Lists.transform(res.getResource().getChildResources(), this.getWrappingFunction(res.getResource())));
            }
            List<RuntimeResource.Builder> childRuntimeResources = this.getRuntimeResources(childResources);
            runtimeResources.add(new RuntimeResource.Builder(resourcesWithSameRegex, childRuntimeResources, (String)entry.getKey()));
        }
        return runtimeResources;
    }

    private Function<Resource, RuntimeResource.ResourceWrapper> getWrappingFunction(final Resource parent) {
        return new Function<Resource, RuntimeResource.ResourceWrapper>(){

            public RuntimeResource.ResourceWrapper apply(Resource child) {
                return new RuntimeResource.ResourceWrapper(parent, child);
            }
        };
    }

    public List<RuntimeResource> getRuntimeResources() {
        return this.runtimeResources;
    }
}

