/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.htmljson;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;

public final class HtmlJsonProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    public boolean isWriteable(Class clazz, Type type, Annotation[] antns, MediaType mt) {
        ParameterizedType pt;
        Type[] args;
        if (!mt.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return false;
        }
        if (clazz.isArray()) {
            return Models.isModel(clazz.getComponentType());
        }
        if (List.class.isAssignableFrom(clazz) && type instanceof ParameterizedType && (args = (pt = (ParameterizedType)type).getActualTypeArguments()).length == 1 && args[0] instanceof Class) {
            return Models.isModel((Class)((Class)args[0]));
        }
        return Models.isModel((Class)clazz);
    }

    public long getSize(Object t, Class type, Type type1, Annotation[] antns, MediaType mt) {
        return -1L;
    }

    public void writeTo(Object t, Class type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap mm, OutputStream out) throws IOException, WebApplicationException {
        this.dump(t, out);
    }

    private void dump(Object t, OutputStream out) throws IOException {
        if (t instanceof Object[]) {
            Object[] arr = (Object[])t;
            out.write(91);
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    out.write(44);
                }
                this.dump(arr[i], out);
            }
            out.write(93);
        } else {
            out.write(t.toString().getBytes("UTF-8"));
        }
    }

    public boolean isReadable(Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return this.isWriteable(type, type1, antns, mt);
    }

    public Object readFrom(Class<Object> clazz, Type type, Annotation[] antns, MediaType mt, MultivaluedMap<String, String> mm, InputStream in) throws IOException, WebApplicationException {
        BrwsrCtx def = BrwsrCtx.findDefault(HtmlJsonProvider.class);
        if (clazz.isArray()) {
            ArrayList res = new ArrayList();
            Class<?> cmp = clazz.getComponentType();
            Models.parse((BrwsrCtx)def, cmp, (InputStream)in, res);
            Object[] arr = (Object[])Array.newInstance(cmp, res.size());
            return res.toArray(arr);
        }
        if (clazz.isAssignableFrom(List.class) && type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length == 1 && ((ParameterizedType)type).getActualTypeArguments()[0] instanceof Class) {
            ArrayList res = new ArrayList();
            Class cmp = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            Models.parse((BrwsrCtx)def, (Class)cmp, (InputStream)in, res);
            return res;
        }
        return Models.parse((BrwsrCtx)def, clazz, (InputStream)in);
    }
}

