/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.htmljson;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;

public final class HtmlJsonProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Logger LOG = Logger.getLogger(HtmlJsonProvider.class.getName());

    public boolean isWriteable(Class type, Type type1, Annotation[] antns, MediaType mt) {
        if (!mt.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return false;
        }
        return Models.isModel((Class)type);
    }

    public long getSize(Object t, Class type, Type type1, Annotation[] antns, MediaType mt) {
        return -1L;
    }

    public void writeTo(Object t, Class type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap mm, OutputStream out) throws IOException, WebApplicationException {
        out.write(t.toString().getBytes("UTF-8"));
    }

    public boolean isReadable(Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return this.isWriteable(type, type1, antns, mt);
    }

    public Object readFrom(Class<Object> type, Type type1, Annotation[] antns, MediaType mt, MultivaluedMap<String, String> mm, InputStream in) throws IOException, WebApplicationException {
        BrwsrCtx def = BrwsrCtx.findDefault(HtmlJsonProvider.class);
        return Models.parse((BrwsrCtx)def, type, (InputStream)in);
    }
}

