/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jaxb.internal;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Provider;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.jaxb.internal.LocalizationMessages;
import org.xml.sax.InputSource;

public class JaxbStringReaderProvider {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private final Value<ContextResolver<JAXBContext>> mtContext;
    private final Value<ContextResolver<Unmarshaller>> mtUnmarshaller;

    public JaxbStringReaderProvider(final Providers ps) {
        this.mtContext = Values.lazy((Value)new Value<ContextResolver<JAXBContext>>(){

            public ContextResolver<JAXBContext> get() {
                return ps.getContextResolver(JAXBContext.class, null);
            }
        });
        this.mtUnmarshaller = Values.lazy((Value)new Value<ContextResolver<Unmarshaller>>(){

            public ContextResolver<Unmarshaller> get() {
                return ps.getContextResolver(Unmarshaller.class, null);
            }
        });
    }

    protected final Unmarshaller getUnmarshaller(Class type) throws JAXBException {
        Unmarshaller u;
        ContextResolver unmarshallerContextResolver = (ContextResolver)this.mtUnmarshaller.get();
        if (unmarshallerContextResolver != null && (u = (Unmarshaller)unmarshallerContextResolver.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type).createUnmarshaller();
    }

    private JAXBContext getJAXBContext(Class type) throws JAXBException {
        JAXBContext c;
        ContextResolver jaxbContextContextResolver = (ContextResolver)this.mtContext.get();
        if (jaxbContextContextResolver != null && (c = (JAXBContext)jaxbContextContextResolver.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = jaxbContexts.get(type);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, c);
            }
            return c;
        }
    }

    public static class RootElementProvider
    extends JaxbStringReaderProvider
    implements ParamConverterProvider {
        private final Provider<SAXParserFactory> spfProvider;

        public RootElementProvider(@Context Provider<SAXParserFactory> spfProvider, @Context Providers ps) {
            super(ps);
            this.spfProvider = spfProvider;
        }

        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            boolean supported;
            boolean bl = supported = rawType.getAnnotation(XmlRootElement.class) != null || rawType.getAnnotation(XmlType.class) != null;
            if (!supported) {
                return null;
            }
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    try {
                        SAXSource source = new SAXSource(((SAXParserFactory)spfProvider.get()).newSAXParser().getXMLReader(), new InputSource(new StringReader(value)));
                        Unmarshaller u = this.getUnmarshaller(rawType);
                        if (rawType.isAnnotationPresent(XmlRootElement.class)) {
                            return rawType.cast(u.unmarshal((Source)source));
                        }
                        return u.unmarshal((Source)source, rawType).getValue();
                    }
                    catch (UnmarshalException ex) {
                        throw new ExtractorException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(rawType), (Throwable)ex);
                    }
                    catch (JAXBException ex) {
                        throw new ProcessingException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(rawType), (Throwable)ex);
                    }
                    catch (Exception ex) {
                        throw new ProcessingException(LocalizationMessages.ERROR_UNMARSHALLING_JAXB(rawType), (Throwable)ex);
                    }
                }

                public String toString(T value) throws IllegalArgumentException {
                    return "test";
                }
            };
        }
    }
}

