
package org.glassfish.jersey.jsonb;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.jsonb.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableERROR_JSONB_DESERIALIZATION() {
        return messageFactory.getMessage("error.jsonb.deserialization");
    }

    /**
     * Error deserializing object from entity stream.
     * 
     */
    public static String ERROR_JSONB_DESERIALIZATION() {
        return localizer.localize(localizableERROR_JSONB_DESERIALIZATION());
    }

    public static Localizable localizableERROR_JSONB_SERIALIZATION() {
        return messageFactory.getMessage("error.jsonb.serialization");
    }

    /**
     * Error writing JSON-B serialized object.
     * 
     */
    public static String ERROR_JSONB_SERIALIZATION() {
        return localizer.localize(localizableERROR_JSONB_SERIALIZATION());
    }

}
