/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jackson.internal;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonMapperConfigurator;

@Singleton
public class DefaultJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider {
    private Configuration commonConfig;
    private static final String EXCLUDE_MODULE_NAME = "JaxbAnnotationModule";

    @Inject
    public DefaultJacksonJaxbJsonProvider(Providers providers, Configuration config) {
        this.commonConfig = config;
        this._providers = providers;
    }

    public DefaultJacksonJaxbJsonProvider(Annotations ... annotationsToUse) {
        super(annotationsToUse);
    }

    @PostConstruct
    private void findAndRegisterModules() {
        ObjectMapper defaultMapper = ((JsonMapperConfigurator)this._mapperConfig).getDefaultMapper();
        ObjectMapper mapper = ((JsonMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        List<Module> modules = this.filterModules();
        defaultMapper.registerModules(modules);
        if (mapper != null) {
            mapper.registerModules(modules);
        }
    }

    private List<Module> filterModules() {
        String disabledModules = (String)CommonProperties.getValue((Map)this.commonConfig.getProperties(), (RuntimeType)this.commonConfig.getRuntimeType(), (String)"jersey.config.json.jackson.disabled.modules", String.class);
        String enabledModules = (String)CommonProperties.getValue((Map)this.commonConfig.getProperties(), (RuntimeType)this.commonConfig.getRuntimeType(), (String)"jersey.config.json.jackson.enabled.modules", String.class);
        List modules = ObjectMapper.findModules();
        modules.removeIf(mod -> mod.getModuleName().contains(EXCLUDE_MODULE_NAME));
        if (enabledModules != null && !enabledModules.isEmpty()) {
            List<String> enabledModulesList = Arrays.asList(enabledModules.split(","));
            modules.removeIf(mod -> !enabledModulesList.contains(mod.getModuleName()));
        } else if (disabledModules != null && !disabledModules.isEmpty()) {
            List<String> disabledModulesList = Arrays.asList(disabledModules.split(","));
            modules.removeIf(mod -> disabledModulesList.contains(mod.getModuleName()));
        }
        return modules;
    }
}

