/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jackson;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.util.Map;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonMappingExceptionMapper;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonParseExceptionMapper;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.message.filtering.EntityFilteringFeature;

public class JacksonFeature
implements Feature {
    private final boolean registerExceptionMappers;
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    public JacksonFeature() {
        this(true);
    }

    private JacksonFeature(boolean registerExceptionMappers) {
        this.registerExceptionMappers = registerExceptionMappers;
    }

    public static JacksonFeature withExceptionMappers() {
        return new JacksonFeature();
    }

    public static JacksonFeature withoutExceptionMappers() {
        return new JacksonFeature(false);
    }

    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = (String)CommonProperties.getValue((Map)config.getProperties(), (RuntimeType)config.getRuntimeType(), (String)"jersey.config.jsonFeature", (Object)JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime((String)"jersey.config.jsonFeature", (RuntimeType)config.getRuntimeType()), (Object)JSON_FEATURE);
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            if (this.registerExceptionMappers) {
                context.register(JsonParseExceptionMapper.class);
                context.register(JsonMappingExceptionMapper.class);
            }
            if (EntityFilteringFeature.enabled((Configuration)config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, new Class[]{MessageBodyReader.class, MessageBodyWriter.class});
            } else {
                context.register(JacksonJaxbJsonProvider.class, new Class[]{MessageBodyReader.class, MessageBodyWriter.class});
            }
        }
        return true;
    }
}

