/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison;

import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.glassfish.jersey.jettison.JettisonConfiguration;
import org.glassfish.jersey.jettison.JettisonConfigured;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.glassfish.jersey.jettison.JettisonUnmarshaller;
import org.glassfish.jersey.jettison.internal.BaseJsonMarshaller;
import org.glassfish.jersey.jettison.internal.BaseJsonUnmarshaller;
import org.glassfish.jersey.jettison.internal.JettisonJaxbMarshaller;
import org.glassfish.jersey.jettison.internal.JettisonJaxbUnmarshaller;

public final class JettisonJaxbContext
extends JAXBContext
implements JettisonConfigured {
    private JettisonConfiguration jsonConfiguration;
    private final JAXBContext jaxbContext;

    public JettisonJaxbContext(Class ... classesToBeBound) throws JAXBException {
        this(JettisonConfiguration.DEFAULT, classesToBeBound);
    }

    public JettisonJaxbContext(JettisonConfiguration config, Class ... classesToBeBound) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jsonConfiguration = config;
        this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound);
    }

    public JettisonJaxbContext(Class[] classesToBeBound, Map<String, Object> properties) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound, properties);
        if (this.jsonConfiguration == null) {
            this.jsonConfiguration = JettisonConfiguration.DEFAULT;
        }
    }

    public JettisonJaxbContext(JettisonConfiguration config, Class[] classesToBeBound, Map<String, Object> properties) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jsonConfiguration = config;
        this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound, properties);
    }

    public JettisonJaxbContext(String contextPath) throws JAXBException {
        this(JettisonConfiguration.DEFAULT, contextPath);
    }

    public JettisonJaxbContext(JettisonConfiguration config, String contextPath) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)Thread.currentThread().getContextClassLoader());
        this.jsonConfiguration = config;
    }

    public JettisonJaxbContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader);
        this.jsonConfiguration = JettisonConfiguration.DEFAULT;
    }

    public JettisonJaxbContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, properties);
        if (this.jsonConfiguration == null) {
            this.jsonConfiguration = JettisonConfiguration.DEFAULT;
        }
    }

    public JettisonJaxbContext(JettisonConfiguration config, String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (config == null) {
            throw new IllegalArgumentException("JSONConfiguration MUST not be null");
        }
        this.jaxbContext = JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, properties);
        this.jsonConfiguration = config;
    }

    public static JettisonMarshaller getJSONMarshaller(Marshaller marshaller) {
        if (marshaller instanceof JettisonMarshaller) {
            return (JettisonMarshaller)marshaller;
        }
        return new BaseJsonMarshaller(marshaller, JettisonConfiguration.DEFAULT);
    }

    public static JettisonUnmarshaller getJSONUnmarshaller(Unmarshaller unmarshaller) {
        if (unmarshaller instanceof JettisonUnmarshaller) {
            return (JettisonUnmarshaller)unmarshaller;
        }
        return new BaseJsonUnmarshaller(unmarshaller, JettisonConfiguration.DEFAULT);
    }

    @Override
    public JettisonConfiguration getJSONConfiguration() {
        return this.jsonConfiguration;
    }

    public JettisonUnmarshaller createJsonUnmarshaller() throws JAXBException {
        return new JettisonJaxbUnmarshaller(this, this.getJSONConfiguration());
    }

    public JettisonMarshaller createJsonMarshaller() throws JAXBException {
        return new JettisonJaxbMarshaller(this, this.getJSONConfiguration());
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        return new JettisonJaxbUnmarshaller(this.jaxbContext, this.getJSONConfiguration());
    }

    public Marshaller createMarshaller() throws JAXBException {
        return new JettisonJaxbMarshaller(this.jaxbContext, this.getJSONConfiguration());
    }

    public Validator createValidator() throws JAXBException {
        return this.jaxbContext.createValidator();
    }
}

