/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JettisonConfig {
    private final Notation notation;
    private final Map<String, String> jsonXml2JsonNs;
    public static final JettisonConfig DEFAULT = JettisonConfig.mappedJettison().build();

    private JettisonConfig(Builder b) {
        this.notation = b.notation;
        this.jsonXml2JsonNs = b.jsonXml2JsonNs;
    }

    public static JettisonConfig createJSONConfiguration(JettisonConfig c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("JSONConfiguration can't be null");
        }
        Builder b = JettisonConfig.copyBuilder(c);
        return b.build();
    }

    public static MappedJettisonBuilder mappedJettison() {
        return new MappedJettisonBuilder(Notation.MAPPED_JETTISON);
    }

    public static Builder badgerFish() {
        return new Builder(Notation.BADGERFISH);
    }

    public static Builder copyBuilder(JettisonConfig jc) {
        Builder result = new Builder(jc.getNotation());
        switch (jc.notation) {
            case BADGERFISH: {
                result = new Builder(jc.getNotation());
                break;
            }
            case MAPPED_JETTISON: {
                result = new MappedJettisonBuilder(jc.getNotation());
            }
        }
        result.copyAttributes(jc);
        return result;
    }

    public Notation getNotation() {
        return this.notation;
    }

    public Map<String, String> getXml2JsonNs() {
        return this.jsonXml2JsonNs != null ? Collections.unmodifiableMap(this.jsonXml2JsonNs) : null;
    }

    public String toString() {
        return String.format("{notation:%s}", new Object[]{this.notation});
    }

    public static class MappedJettisonBuilder
    extends Builder {
        private MappedJettisonBuilder(Notation notation) {
            super(notation);
        }

        public MappedJettisonBuilder xml2JsonNs(Map<String, String> jsonXml2JsonNs) {
            this.jsonXml2JsonNs = jsonXml2JsonNs;
            return this;
        }
    }

    public static class Builder {
        private final Notation notation;
        protected Map<String, String> jsonXml2JsonNs = new HashMap<String, String>(0);

        private Builder(Notation notation) {
            this.notation = notation;
        }

        public JettisonConfig build() {
            return new JettisonConfig(this);
        }

        private void copyAttributes(JettisonConfig jc) {
            this.jsonXml2JsonNs.putAll(jc.getXml2JsonNs());
        }
    }

    public static enum Notation {
        MAPPED_JETTISON,
        BADGERFISH;

    }
}

