/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal.entity;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.glassfish.jersey.jaxb.internal.AbstractRootElementJaxbProvider;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;

public class JettisonRootElementProvider
extends AbstractRootElementJaxbProvider {
    JettisonRootElementProvider(Providers ps, Configuration config) {
        super(ps, config);
    }

    JettisonRootElementProvider(Providers ps, MediaType mt, Configuration config) {
        super(ps, mt, config);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type, genericType, annotations, mediaType);
    }

    protected final Object readFrom(Class<Object> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException {
        Charset c = JettisonRootElementProvider.getCharset((MediaType)mediaType);
        return JettisonJaxbContext.getJSONUnmarshaller(u).unmarshalFromJSON(new InputStreamReader(entityStream, c), type);
    }

    protected void writeTo(Object t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException {
        JettisonMarshaller jsonMarshaller = JettisonJaxbContext.getJSONMarshaller(m);
        if (this.isFormattedOutput()) {
            jsonMarshaller.setProperty("org.glassfish.jersey.media.json.JsonMarshaller.formatted", true);
        }
        jsonMarshaller.marshallToJSON(t, new OutputStreamWriter(entityStream, c));
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JettisonRootElementProvider {
        @Inject
        public General(@Context Providers ps, @Context Configuration config) {
            super(ps, config);
        }

        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JettisonRootElementProvider {
        @Inject
        public App(@Context Providers ps, @Context Configuration config) {
            super(ps, MediaType.APPLICATION_JSON_TYPE, config);
        }
    }
}

